% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmoid.R
\name{sigmoid}
\alias{sigmoid}
\title{Sigmoid}
\usage{
sigmoid(x, method = c("logistic", "Gompertz", "tanh"), inverse = FALSE,
  SoftMax = FALSE, ...)
}
\arguments{
\item{x}{numeric vector}

\item{method}{type of sigmoid function}

\item{inverse}{use the inverse of the method (reverses)}

\item{SoftMax}{use SoftMax preprocessing}

\item{...}{arguments to pass on the method}
}
\description{
computes sigmoid nonlinearity
}
\examples{
# create input vector
a <- seq(-10,10)

# use sigmoid with default standard logistic
( b <- sigmoid(a) )

# show shape
plot(b)

# inverse
hist( a - sigmoid(b, inverse=TRUE) )

# with SoftMax
( c <- sigmoid(a, SoftMax=TRUE) )

# show difference
hist(b-c)
}

