% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCTest.R
\name{testAUCpair}
\alias{testAUCpair}
\title{Test AUC pair results.}
\usage{
testAUCpair(d, model1Name, model2Name, yName, yTarget, ...,
  returnScores = FALSE, nrep = 100, parallelCluster = NULL)
}
\arguments{
\item{d}{data.frame}

\item{model1Name}{character model 1 column name}

\item{model2Name}{character model 2 column name}

\item{yName}{character outcome column name}

\item{yTarget}{target to match to y}

\item{...}{extra arguments (not used)}

\item{returnScores}{logical if TRUE return detailed resampledScores}

\item{nrep}{number of re-sample repetition to estimate p value.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow}
}
\value{
AUC pair test
}
\description{
Estimate signficance of difference in two AUCs by resampling.
}
\examples{

set.seed(25325)
d <- data.frame(x1=c(1,2,3,4,5,6,7,7),
                x2=1,
                y=c(FALSE,TRUE,FALSE,FALSE,
                    TRUE,TRUE,FALSE,TRUE))
testAUCpair(d,'x1','x2','y',TRUE)


}

