% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculatePipThreshold.R
\name{calculate_pip_threshold}
\alias{calculate_pip_threshold}
\title{Calculate PIP Threshold}
\usage{
calculate_pip_threshold(
  y,
  absCV,
  sampSize,
  coeffs_ls = list(A = 0, K = 1.43462, C = 1.59948, betaAbsCV = 0.56615, betaSampSize =
    0.51345),
  na.rm = TRUE
)
}
\arguments{
\item{y}{a response vector for BKMR}

\item{absCV}{If \code{y} is not supplied, the absolute value of the coefficient
of variation of the response}

\item{sampSize}{If \code{y} is not supplied, the number of observations included
in the response}

\item{coeffs_ls}{A list of Richard's Curve parameters. See Details.}

\item{na.rm}{Remove missing values from \code{y}? Defaults to \code{TRUE}}
}
\value{
A single numeric value; the output of the Richard's Four-Parameter
Logistic Regression curve with the coefficient values supplied in
\code{coeffs_ls}.
}
\description{
Given a response vector (or statistics from this vector),
calculate a PIP threshold that should preserve close to a nominal 5\% test
size for Bayesian Kernel Machine Regression (BKMR) feature selection.
}
\details{
CalculatePipThreshold function is designed to model the relationship between PIP(q95),
coefficient of variation (CV), and sample size using a form of four-parameter
logistic regression (Richard Curve). This function employs the \code{nls} function
from the R \code{stats} package, utilizing the Levenberg-Marquardt algorithm for
optimization to ensure robust parameter estimation.
\deqn{
  PIP(q_{95}) = A + \frac{K-A}{ (C + \exp(-\beta_1x_1) )^{\beta_2x_2} }
}
Where-

A: Fixed left asymptote (0);

K: Right asymptote;

C: Constant;

\eqn{\beta_1, \beta_2}: Midpoint shift parameters for CV and sample size;

x1: Log2-transformed |CV| (log2(|CV|));

x2: Log-transformed sample size (log10(Sample Size)).

The detailed explanation of how we calculated the values in \code{coeffs_ls} can
be found in <......>.

For more information on Richard's curve, see
\url{https://en.wikipedia.org/wiki/Generalised_logistic_function}
}
\examples{
calculate_pip_threshold(absCV = 7.5, sampSize = 300)
# should equal 0.6829892

}
