% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vchisq}
\alias{vchisq}
\title{Variate Generation for Chi-Squared Distribution}
\usage{
vchisq(n, df, ncp = 0, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{df}{Degrees of freedom (non-negative, but can be non-integer)}

\item{ncp}{Non-centrality parameter (non-negative)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qchisq]{stats::qchisq}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qchisq]{stats::qchisq}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of chi-squared random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Chi-Squared Distribution
}
\details{
Generates random variates from the chi-squared distribution.

  Chi-Squared variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qchisq]{stats::qchisq}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vchisq} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The chi-squared distribution with \code{df} = \eqn{n \geq 0}{n >= 0} degrees
of freedom has density

    \deqn{f_n(x) = \frac{1}{2^{n/2} \ \Gamma(n/2)} x^{n/2-1} e^{-x/2}}{%
          f_n(x) = 1 / (2^(n/2) Γ(n/2)) x^(n/2-1) e^(-x/2)}

for \eqn{x > 0}. The mean and variance are \eqn{n} and \eqn{2n}.


The non-central chi-squared distribution with \code{df} = n degrees of
freedom and non-centrality parameter \code{ncp} \eqn{= \lambda}{= λ} has density

    \deqn{f(x) = e^{-\lambda/2} \sum_{r=0}^\infty \frac{(\lambda/2)^r}{r!} f_{n + 2r}(x)}{%
          f(x) = exp(-λ/2) SUM_{r=0}^∞ ((λ/2)^r / r!) dchisq(x, df + 2r)}

for \eqn{x \geq 0}{x >= 0}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qchisq
 vchisq(3, df = 3, ncp = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qchisq
 vchisq(3, 3, stream = 1)
 vchisq(3, 3, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qchisq
 vchisq(1, 3, stream = 1)
 vchisq(1, 3, stream = 2)
 vchisq(1, 3, stream = 1)
 vchisq(1, 3, stream = 2)
 vchisq(1, 3, stream = 1)
 vchisq(1, 3, stream = 2)

 set.seed(8675309)
 variates <- vchisq(1000, 3, stream = 1)
 set.seed(8675309)
 variates <- vchisq(1000, 3, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rchisq]{stats::rchisq}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
