% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventTracking.R
\name{getEventsAll}
\alias{getEventsAll}
\title{Number of recruited/censored/ongoing Patients.}
\usage{
getEventsAll(data, t)
}
\arguments{
\item{data}{(\code{data.frame})\cr illness-death data set in \verb{1rowPatient} format.}

\item{t}{(\code{numeric})\cr  study time-point.}
}
\value{
This function returns number of recruited patients,
number of censored and number of patients under observations.
}
\description{
Number of recruited/censored/ongoing Patients.
}
\examples{
transition1 <- weibull_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6, p01 = 0.8, p02 = 0.9, p12 = 1)
transition2 <- weibull_transition(h01 = 1, h02 = 1.3, h12 = 1.7, p01 = 1.1, p02 = 0.9, p12 = 1.1)

simStudy <- getOneClinicalTrial(
  nPat = c(20, 20), transitionByArm = list(transition1, transition2),
  dropout = list(rate = 0.6, time = 10),
  accrual = list(param = "time", value = 0)
)
simStudyWide <- getDatasetWideFormat(simStudy)
getEventsAll(data = simStudyWide, t = 1.5)
}
