% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventTracking.R
\name{getTimePoint}
\alias{getTimePoint}
\title{Time-point by which a specified number of events occurred.}
\usage{
getTimePoint(data, eventNum, typeEvent, byArm = FALSE)
}
\arguments{
\item{data}{(\code{data.frame})\cr illness-death data set in \verb{1rowPatient} format.}

\item{eventNum}{(\code{int})\cr number of events.}

\item{typeEvent}{(\code{string})\cr type of event. Possible values are \code{PFS} and \code{OS}.}

\item{byArm}{(\code{logical})\cr if \code{TRUE} time-point per treatment arm, else joint evaluation
of treatment arms.}
}
\value{
This returns  the time-point by which \code{eventNum} of \code{typeEvent}-events occurred.
}
\description{
This returns the study time-point by which a specified number of events (PFS or OS) occurred.
}
\examples{
transition1 <- weibull_transition(h01 = 1.2, h02 = 1.5, h12 = 1.6, p01 = 0.8, p02 = 0.9, p12 = 1)
transition2 <- weibull_transition(h01 = 1, h02 = 1.3, h12 = 1.7, p01 = 1.1, p02 = 0.9, p12 = 1.1)

simStudy <- getOneClinicalTrial(
  nPat = c(20, 20), transitionByArm = list(transition1, transition2),
  dropout = list(rate = 0.3, time = 10),
  accrual = list(param = "time", value = 0)
)
simStudyWide <- getDatasetWideFormat(simStudy)
getTimePoint(simStudyWide, eventNum = 10, typeEvent = "OS", byArm = FALSE)
}
