% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densify.R
\name{densifyCluster}
\alias{densifyCluster}
\title{Densify clusters}
\usage{
densifyCluster(F, CL, box, ctrl, weight = 10, info = FALSE, cl = NULL,
  parallel.option = getOption("parallel.option", "lapply"))
}
\arguments{
\item{F}{non-overlapping particle system}

\item{CL}{cluster list, defining the different cluster regions}

\item{box}{simulation box}

\item{ctrl}{control arguments passed to function \code{GenSA}}

\item{weight}{optional: weight factor \code{weight=10} (default)}

\item{info}{optional: logical, if TRUE return result from \code{GenSA} call}

\item{cl}{optional: cluster object, see package \code{snow}}

\item{parallel.option}{optional: In case of \code{mclapply} the function \code{mclapply} 
is used from the \code{parallel} package}
}
\value{
a list of all objects (including newly densified regions) named \code{S}
						    and a named list of clustered regions \code{cluster}
}
\description{
Densification of objects within a predefined ball
}
\details{
This densification method requires package\code{\link[GenSA]{GenSA}} to be installed. Additionally for
performance reasons it is recommended to make use of parallization by package 'parallel' installed and 
available or some 'cluster' object derived from it.

Parts of the (reinforcement) geometry system are densified in order to account for regions where some
objects stick together more close than in other regions of the simulation box. These so-called
clusters are generated by a densification algorithm minimizing some energy 
of object positions and their (overlap) distances within an enclosing ball of objects with
a predefined cluster radius. In order to prevent overlaps between objects one possibly has to increase 
the \code{weight} factor iteratively and run it again if some objects happen to overlap.
}
\examples{
\dontrun{

## Simulate and densify particle system
## densify and include a secondary phase
	
# Not on MS-Windows 	
#library("parallel")
#options(mc.cores=detectCores())
#options(parallel.option="mclapply")
 
# simulation box either this kind of list
# or use object spatstat::box3 
box <- list("xrange"=c(0,3),"yrange"=c(0,3),"zrange"=c(0,9))

# parameter for spheroids simulation 
theta <- list("size"=list(0.25),"shape"=list("s"=0.25), "orientation"=list("kappa"=1))

# for ease of use: constant size particles
S <- simParticle(theta,lam=15,box=box,mu=c(0,1,0))

param <- list("size"=list(0.075), "shape"=list("s"=0.75),"orientation"=list("kappa"=1))
F  <- simFerrit(param,lam=2,box=box,mu=c(0,1,0)) 

# apply RSA, this may take some 
RSA <- rsa(S, box, F=F, pl = 10)

## show 3d spheroids (non-overlapping)
# cols <- c("#0000FF","#00FF00","#FF0000","#FF00FF","#FFFF00","#00FFFF")
# spheroids3d(RSA[1:length(S)], box, col=cols)	
# spheroids3d(RSA[length(S):(length(S)+length(F))], box, col="gray")

# construct clusters
param <- list("r"=0.35)
CLUST <- simCluster(RSA, param, 0.1, box, verbose=TRUE)
cat("cluster length: ",length(CLUST),"\\n")

# X <- do.call(rbind,lapply(CLUST, function(x) c(x$center,x$r)))
# invisible(lapply(CLUST, function(x) rgl::spheres3d(X[,1:3],radius=X[,4],col="gray",alpha=0.2)))
# cols <- c("#0000FF","#00FF00","#FF0000","#FF00FF","#FFFF00","#00FFFF")
# invisible(lapply(CLUST, function(x) spheroids3d(RSA[x$id],box,col=cols)))

# controls for 'GenSA'
ctrl <- list(threshold.stop=0.01,max.call=10000,verbose=FALSE)
# densify
RET <- densifyCluster(RSA, CLUST, box, ctrl, weight=100,cl = NULL)	

S <- RET$S
CL <- RET$cluster

## show densified clusters 
# X <- do.call(rbind,lapply(CLUST, function(x) c(x$center,x$r)))
# invisible(lapply(CLUST, function(x)
# rgl::spheres3d(x=X[,1:3],radius=X[,4],col="gray",alpha=0.2)))
# invisible(lapply(CL, function(x) { spheroids3d(x, box, col=cols) }))

## save results	
# path <- "/"
# save(S,file=paste0(path,"test_particle_S.rda"))
# save(CL,file=paste0(path,"test_particle_CL.rda"))
	
}	
}

