% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/specifyInput.R
\name{specifyInput}
\alias{specifyInput}
\title{create an object of class 'dataObj' required for further processing}
\usage{
specifyInput(data, hhid, hhsize = NULL, pid = NULL, weight = NULL,
  strata = NULL, population = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} or \code{data.table} featuring sample data.}

\item{hhid}{character vector of length 1 specifying variable containing
household ids within slot \code{data}.}

\item{hhsize}{character vector of length 1 specifying variable containing
household sizes within slot \code{data}. If NULL, household sizes are
automatically calculated.}

\item{pid}{character vector of length 1 specifying variable containing
person ids within slot \code{data}. If NULL, person ids are automatically
calculated.}

\item{weight}{character vector of length 1 specifying variable holding
sampling weights within slot \code{data}.}

\item{strata}{character vector of length 1 specifing variable name within
slot \code{data} of variable holding information on strata, e.g. regions or
NULL if such variable does not exist.}

\item{population}{TRUE/FALSE vector of length 1 specifing if the data object is a sample or a population
NULL if such variable does not exist.}
}
\description{
create an standardized input object of class 'dataObj' containing
information on weights, household ids, household sizes, person ids and
optionally strata. Outputs of this function are typically used in
\code{\link{simStructure}}.
}
\examples{
data(eusilcS)
inp <- specifyInput(data=eusilcS, hhid="db030", weight="rb050", strata="db040")
class(inp)
inp
}
\author{
Bernhard Meindl
}
\keyword{method}

