% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimBetaN}
\alias{SimBetaN}
\title{Simulate Transition Matrices
from the Multivariate Normal Distribution}
\usage{
SimBetaN(n, beta, vcov_beta_vec_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{beta}{Numeric matrix.
The transition matrix (\eqn{\boldsymbol{\beta}}).}

\item{vcov_beta_vec_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_beta_vec))})
of the sampling variance-covariance matrix
\eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.}
}
\description{
This function simulates random transition matrices
from the multivariate normal distribution.
The function ensures that the generated transition matrices are stationary
using \code{\link[=TestStationarity]{TestStationarity()}}.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0, 0, 0.5
  ),
  nrow = 3
)
n <- 10
vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
SimBetaN(n = n, beta = beta, vcov_beta_vec_l = vcov_beta_vec_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{SimPhiN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
