% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TestPhi}
\alias{TestPhi}
\title{Test the Drift Matrix}
\usage{
TestPhi(phi)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).}
}
\description{
Both have to be true for the function to return \code{TRUE}.
\itemize{
\item Test that the real part of all eigenvalues of \eqn{\boldsymbol{\Phi}}
are less than zero.
\item Test that the diagonal values of \eqn{\boldsymbol{\Phi}}
are between 0 to negative inifinity.
}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
TestPhi(phi = phi)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{PBSSMFixed}()},
\code{\link{PBSSMLinSDEFixed}()},
\code{\link{PBSSMOUFixed}()},
\code{\link{PBSSMVARFixed}()},
\code{\link{SimBetaN}()},
\code{\link{SimPhiN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{test}
