% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_simaerep.R
\name{simaerep}
\alias{simaerep}
\title{create simaerep object}
\usage{
simaerep(
  df_visit,
  param_site_aggr = list(method = "med75_adj", min_pat_pool = 0.2),
  param_sim_sites = list(r = 1000, poisson_test = FALSE, prob_lower = TRUE),
  param_eval_sites = list(method = "BH"),
  progress = TRUE,
  check = TRUE,
  env = parent.frame(),
  under_only = TRUE
)
}
\arguments{
\item{df_visit}{data frame with columns: study_id, site_number, patnum, visit,
n_ae}

\item{param_site_aggr}{list of parameters passed to \link[=site_aggr]{site_aggr()},
Default: list(method = "med75_adj", min_pat_pool = 0.2)}

\item{param_sim_sites}{list of parameters passed to \link[=sim_sites]{sim_sites()},
Default: list(r = 1000, poisson_test = FALSE, prob_lower = TRUE)}

\item{param_eval_sites}{list of parameters passed to
\link[=eval_sites]{eval_sites()}, Default: list(method = "BH")}

\item{progress}{logical, display progress bar, Default = TRUE}

\item{check}{logical, perform data check and attempt repair with
\link[=check_df_visit]{check_df_visit()}, computationally expensive on large data
sets. Default: TRUE}

\item{env}{optional, provide environment of original visit data, Default:
parent.frame()}

\item{under_only, }{logical compute under-reporting probabilities only,
superseeds under_only parameter passed to \link[=eval_sites]{eval_sites()} and
\link[=sim_sites]{sim_sites()}, Default: TRUE}
}
\value{
simaerep object
}
\description{
simulate AE under-reporting probabilities
}
\details{
executes \link[=site_aggr]{site_aggr()}, \link[=sim_sites]{sim_sites()} and
\link[=eval_sites]{eval_sites()} on original visit data and stores all
intermediate results. Stores lazy reference to original visit data for
facilitated plotting using generic plot(x).
}
\examples{

df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  frac_site_with_ur = 0.4,
  ur_rate = 0.6
)

df_visit$study_id <- "A"

aerep <- simaerep(df_visit)

aerep

str(aerep)

}
\seealso{
\link[=site_aggr]{site_aggr()}, \link[=sim_sites]{sim_sites()},
\link[=eval_sites]{eval_sites()}, \link[=orivisit]{orivisit()},
\link[=plot.simaerep]{plot.simaerep()}
}
