\name{misclass}
\Rdversion{1.1}
\alias{misclass}

\title{Generates misclassified data}

\description{
  Takes a \code{data.frame} and produces misclassified data.
  Probabilities for the missclassification are given in the \code{mc.matrix}.
}

\usage{
misclass(data.org, mc.matrix, k)
}

\arguments{
  \item{data.org}{ \code{data.frame} containing the factor variables. Must be
    \code{factor}s}
  \item{mc.matrix}{ a \code{list} of matrices giving the probabilities for the
    misclassification. Names of the \code{list} must correspond to the variable
	names in \code{data.org}. The \code{colnames} must be named according to the
	factor levels}
  \item{k}{the exponent for the misclassification matrix}
}

\value{
  A \code{data.frame} containing the misclassified variables
}

\author{ Wolfgang Lederer, \email{wolfgang.lederer@gmail.com}}

\seealso{\code{\link[simex]{mcsimex}}, \code{\link[simex]{build.mc.matrix}},
  \code{\link[simex]{diag.block}}}

\examples{
x1 <- factor(rbinom(100, 1, 0.5))
x2 <- factor(rbinom(100, 2, 0.5))

p1 <- matrix(c(1, 0, 0, 1), nrow = 2)
p2 <- matrix(c(0.8, 0.1, 0.1, 0.1, 0.8, 0.1, 0.1, 0.1, 0.8), nrow = 3)

colnames(p1) <- levels(x1)
colnames(p2) <- levels(x2)

x <- data.frame(x1 = x1, x2 = x2)
mc.matrix <- list(x1 = p1, x2 = p2)

x.mc <- misclass(data.org = x, mc.matrix = mc.matrix, k = 1)

identical(x[, 1], x.mc[, 1]) # TRUE
identical(x[, 2], x.mc[, 2]) # FALSE
}

\keyword{datagen}
