% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{leave}
\alias{leave}
\title{Leave the Trajectory}
\usage{
leave(.trj, prob)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{prob}{a probability or a function returning a probability.}
}
\value{
Returns the trajectory object.
}
\description{
Activity for leaving the trajectory with some probability.
}
\details{
Arrivals that leave the trajectory will set the \code{finished} flag
to \code{FALSE} in the output of \code{\link{get_mon_arrivals}}. Unfinished
arrivals can be handled with a drop-out trajectory that can be set using the
\code{\link{handle_unfinished}} activity.
}
\examples{
set.seed(1234)

traj <- trajectory() \%>\%
  log_("leave with some probability") \%>\%
  leave(function() runif(1) < 0.5) \%>\%
  log_("didn't leave")

simmer() \%>\%
  add_generator("dummy", traj, at(0, 1)) \%>\%
  run() \%>\% invisible

}
\seealso{
\code{\link{handle_unfinished}}, \code{\link{renege_in}}
}
