% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simode_multi.R
\name{plot.list.simode}
\alias{plot.list.simode}
\title{Plot the fit/estimates of a \code{list.simode} object}
\usage{
\method{plot}{list.simode}(x, type = c("fit", "est"), show = c("nls", "im",
  "both"), which = NULL, pars_true = NULL, time = NULL,
  plot_im_smooth = F, legend = F, mfrow = par("mfrow"),
  cols = list(nls_fit = "blue", im_fit = "green", true = "black", obs = "red",
  im_smooth = "magenta"), ...)
}
\arguments{
\item{x}{\code{simode} object returned by a call to \code{\link{simode}}.}

\item{type}{Type of plot - 'fit' to plot the fitted equations
and 'est' to plot the parameter estimates.}

\item{show}{Whether to plot the fit/estimates obtained
using nonlinear least squares ('nls'), integral-matching ('im') or both ('both').}

\item{which}{Which variables to plot in case \code{type='fit'}, or which
parameters to plot in case \code{type='est'}. If empty, the plot will include
all of the variables/parameters in x.}

\item{pars_true}{The true parameter values (if are known). Should be
named using the parameter names. If given, the true values for
the variables/parameters will be added to the plot.}

\item{time}{The time points to use for the fitted curves
(relevant only for \code{type='fit'}).
If not given then the time points of the observations in x will be used.}

\item{plot_im_smooth}{Whether or not to plot the smoothed curves created and
used by the integral-matching procedure (relevant only for \code{type='fit'}).}

\item{legend}{Whether or not to add a figure legend.}

\item{mfrow}{A vector of the form c(nr,nc) setting the layout of
subplots in one plot (see also \code{\link{par}}).}

\item{cols}{List of colors for each element of the plot.}

\item{...}{Additional argument(s) for methods.}
}
\description{
Plot the fit or parameter estimates obtained from a call to \code{simode}
with \code{mc_sets>1}. Plots the mean and standard deviation obtained from
the multiple fits.
}
