% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/si_to_od.R
\name{si_to_od}
\alias{si_to_od}
\title{Prepare OD data frame}
\usage{
si_to_od(origins, destinations, max_dist = Inf, intrazonal = TRUE)
}
\arguments{
\item{origins}{\code{sf} object representing origin locations/zones}

\item{destinations}{\code{sf} object representing destination locations/zones}

\item{max_dist}{Euclidean distance in meters (numeric).
Only OD pairs that are this distance apart or less will be returned
and therefore included in the SIM.}

\item{intrazonal}{Include intrazonal OD pairs?
Intrazonal OD pairs represent movement from one
place in a zone to another place in the same zone.
\code{TRUE} by default.}
}
\value{
An sf data frame
}
\description{
Prepares an OD data frame that next could be used to
estimate movement between origins and destinations
with a spatial interaction model.
}
\details{
In most origin-destination datasets the spatial entities that constitute
origins (typically administrative zones) also represent destinations.
In this 'unipartite' case \code{origins} and \code{destinations} should be passed
the same object, an \code{sf} data frame representing administrative zones.

'Bipartite' datasets, by contrast, represent
"spatial interaction systems where origins cannot act as
destinations and vice versa" (Hasova et al. \href{https://lenkahas.com/files/preprint.pdf}{2022}).

a different
\code{sf} object can be passed to the \code{destinations} argument.
}
\examples{
library(sf)
origins = si_centroids[c(1, 2, 99), ]
destinations = origins
plot(origins$geometry)
odsf = si_to_od(origins, destinations, max_dist = 1200)
plot(odsf)
# note: result contains intrazonal flows represented by linestrings
# with a length of 0, e.g.:
sf::st_coordinates(odsf$geometry[1])
# With different destinations compared with origins
library(sf)
origins = si_centroids[c(2, 99), c(1, 6, 7)]
destinations = si_centroids[1, c(1, 6, 8)]
odsf = si_to_od(origins, destinations)
nrow(odsf) # no intrazonal flows
plot(odsf)
}
