% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_histogram.R
\name{gg_histogram}
\alias{gg_histogram}
\title{Histogram ggplot.}
\usage{
gg_histogram(
  data,
  x_var,
  pal = pal_viridis_mix(1),
  alpha_fill = 0.5,
  alpha_line = 1,
  size_line = 0.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_bins_n = 30,
  x_breaks_n = 5,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  y_breaks_n = 5,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(y_grid = TRUE),
  mobile = FALSE
)
}
\arguments{
\item{data}{A data frame in a structure to be transformed to histogram statistics. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{size_line}{The size of the outlines of histogram areas.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 75.}

\item{x_bins_n}{Number of bins to aim for. Defaults to 30.}

\item{x_breaks_n}{For a numeric x variable, the desired number of intervals on the x scale, as calculated by the}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_breaks_n}{For a numeric y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Histogram ggplot that is not coloured and not facetted.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_histogram(penguins, 
           x_var = body_mass_g)

}
