% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simrec_interim.R
\name{simrecint}
\alias{simrecint}
\title{simrecint}
\usage{
simrecint(data, N, tR, tI)
}
\arguments{
\item{data}{Previously generated data (in patient time), that shall be cut to interim data}

\item{N}{Number of individuals, for which \code{data} was generated}

\item{tR}{Length of the recruitment period (in study time)}

\item{tI}{Timing of the interim analysis (in study time)}
}
\value{
The output is a data.frame consisting of the columns, that were put into, and additionally the following columns:
   \item{rectime}{The recruitment time for each individual (in study time).}
   \item{interimtime}{The time of the interim analysis \code{tI} (in study time).}
   \item{stop_study}{The stopping time for each event in study time.}
 Individuals that are not already recruited at the interim analysis are left out here.
}
\description{
With this function previously simulated data (for example simulated by the use of \code{simrec} or \code{simreccomp})
can be cut to an interim data set.
The simulated data must be in patient time (i.e. time since the patient entered the study),
and must be in the counting process format. Furthermore the dataset must have the variables \code{id}, \code{start}, \code{stop} and \code{status},
like data simulated by the use of \code{simrec} or \code{simreccomp}.
Then for every individual additionally a recruitment time is generated in study time (i.e. time since start of the study),
which is uniformly distributed on \code{[0, tR]}.
The timing of the interim analysis \code{tI} is set in study time and
data are being cut to all data, that are available at the interim analysis.
For further explanations on study time and patient time see the vignette.
If you only wish to simulate a recruitment time, \code{tI} can be set to \code{tR + fu.max} or something bigger.
}
\examples{
### Example - see example for simrec
library(simrec)
N <- 10
dist.x <- c("binomial", "normal")
par.x <- list(0.5, c(0, 1))
beta.x <- c(0.3, 0.2)
dist.z <- "gamma"
par.z <- 0.25
dist.rec <- "weibull"
par.rec <- c(1, 2)
fu.min <- 2
fu.max <- 2
cens.prob <- 0.2

simdata <- simrec(
  N, fu.min, fu.max, cens.prob, dist.x, par.x, beta.x, dist.z,
  par.z, dist.rec, par.rec
)

### Now simulate for each patient a recruitment time in [0,tR=2]
### and cut data to the time of the interim analysis at tI=1:

simdataint <- simrecint(simdata, N = N, tR = 2, tI = 1)
# print(simdataint)  # only run for small N!
}
\seealso{
simrec, simreccomp
}
\author{
Katharina Ingel, Stella Preussler, Antje Jahn-Eimermacher.
Institute of Medical Biostatistics, Epidemiology and Informatics (IMBEI),
University Medical Center of the Johannes Gutenberg-University Mainz, Germany
}
