\newcommand{\CRANpkg}{\href{http://CRAN.R-project.org/package=#1}{\pkg{#1}}}
\name{doApply}
\title{Functions for Iterating Over All Subjobs}
\alias{doLapply}
\alias{doForeach}
\alias{doRmpi}
\alias{doMclapply}
\alias{doClusterApply}
\alias{doRes.equal}
\description{
  \code{doLapply()} iterates over all subjobs (using the non-parallel
  \code{\link{lapply}()}). Similarly, but in parallel, for
  \code{doForeach} (based on CRAN package \CRANpkg{foreach}'s \code{\link[foreach]{foreach}()}),
  \code{doRmpi} (based on \CRANpkg{Rmpi}'s \code{\link[Rmpi]{mpi.apply}()}),
  \code{doMclapply} (based on \pkg{parallel}'s \code{\link{mclapply}()}), and
  \code{doClusterApply} (based on \pkg{parallel}'s \code{\link{clusterApply}()}).

  \code{doRes.equal()} is simple convenience wrapper for
  \code{\link{all.equal}()}, for comparing two results (from the same
  \code{\link{varlist}} and \code{doOne} arguments) of the \code{do*}
  lapply-like functions above.
  }
\usage{
doLapply(vList, seed="seq", repFirst=TRUE,
       sfile=NULL, check=TRUE, doAL=TRUE, subjob.=subjob, monitor=FALSE,
       doOne, ...)
doForeach(vList, cluster=makeCluster(detectCores(), type="PSOCK"),
       cores=NULL, block.size = 1, seed="seq", repFirst=TRUE,
       sfile=NULL, check=TRUE, doAL=TRUE, subjob.=subjob, monitor=FALSE,
       doOne, extraPkgs=character(), exports=character(), ...)
doRmpi(vList,
       nslaves = if((sz <- Rmpi::mpi.universe.size()) <= 1) detectCores() else sz,
       load.balancing=TRUE, block.size = 1, seed="seq", repFirst=TRUE,
       sfile=NULL, check=TRUE, doAL=TRUE, subjob.=subjob, monitor=FALSE,
       doOne, exports=character(), ...)
doMclapply(vList, cores = if(.Platform$OS.type == "windows") 1 else detectCores(),
       load.balancing=TRUE, block.size = 1, seed="seq", repFirst=TRUE,
       sfile=NULL, check=TRUE, doAL=TRUE, subjob.=subjob, monitor=FALSE,
       doOne, ...)
doClusterApply(vList, cluster=makeCluster(detectCores(), type="PSOCK"),
       load.balancing=TRUE, block.size = 1, seed="seq", repFirst=TRUE,
       sfile=NULL, check=TRUE, doAL=TRUE, subjob.=subjob, monitor=FALSE,
       doOne, initExpr, exports=character(), ...)

doRes.equal(x, y, tol = 1e-15, ...)
}
\arguments{
  \item{vList}{a \code{\link{list}} of variable specifications. Each
    variable spec is itself a named list which must contain a
    \code{"value"} component.}
  \item{cluster}{cluster object, typically generated by
    \code{\link{makeCluster}()}. For \code{\link{doForeach}()}, this can
    be \code{NULL} as well, see Details below.}
  \item{cores}{the number of cores. For \code{\link{doForeach}()}, this can
    be \code{NULL} as well, see Details below.}
  \item{nslaves}{the number of workers for \code{doRmpi}, passed
    to package \CRANpkg{Rmpi}'s \code{\link[Rmpi]{mpi.spawn.Rslaves}} when no
    running workers are found.}
  \item{load.balancing}{\code{\link{logical}} indicating whether
    load balancing is used:
    \describe{
      \item{doRmpi()}{\code{\link[Rmpi]{mpi.applyLB}()} is used instead of
	\code{\link[Rmpi]{mpi.apply}()}.}
      \item{doMclapply()}{here, \code{mc.preschedule=!load.balancing}
	determines load balancing.}
      \item{doClusterApply()}{\code{\link{clusterApplyLB}()} instead of
	\code{\link{clusterApply}()}.}
  }}
  \item{block.size}{size of blocks of rows in the virtual grid which are
    computed simultaneously (load-balancing).}
  \item{seed, repFirst}{see \code{\link{subjob}()}.}
  \item{sfile, check, doAL}{see \code{\link{saveSim}()}.}
  \item{subjob.}{a \code{\link{function}} for computing a subjob (one
    row of the virtual grid). Typically \code{\link{subjob}()}.}
  \item{doOne}{a user-supplied \code{\link{function}} for computing one
    row of the (physical) grid.}
  \item{monitor}{a logical or a \code{\link{function}} for producing
    \dQuote{monitoring} output; the function argument list must contain
    the one of \code{\link{printInfo}[["default"]]}.}
  \item{extraPkgs}{\code{\link{character}} vector of packages to be made
    available on the nodes.}
  \item{exports}{\code{\link{character}} vector of functions (for
    \code{\link{doForeach}()} and \code{\link{doClusterApply}()}) or
    objects (for \code{\link{doRmpi}()}) to export.}
  \item{initExpr}{expression initially evaluated on the cluster
    (can be missing).}
  \item{\dots}{additional arguments passed to \code{subjob()} (typically
    further passed on to \code{doOne()}), or, for \code{doRes.equal()}, to
    \code{\link{all.equal}(*)}.}

%% For doRes.equal():
  \item{x,y}{each a result of, say \code{doLapply()} which should be
    compared where sensible, i.e., the first three components
    \code{"value"},\code{"error"},\code{"warning"}, using
    \code{\link{all.equal}}.}
  \item{tol}{passed to \code{\link{all.equal}(*)}.}
}
\value{
  The result of applying \code{subjob()} to all subjobs, converted with
  \code{\link{saveSim}()}.
}
\details{
  See the vignette or references in \code{\link{simsalapar-package}} for
  how to use these functions.

  For reasons to choose \code{"MPI"} as cluster type (if not on Windows),
  see the discussion starting at
  \url{https://stat.ethz.ch/pipermail/r-sig-hpc/2013-April/001647.html}.

  For \code{\link{doForeach}()}, precisely one of \code{cluster} or
  \code{cores} has to be not \code{NULL}. This will determine whether
  the parallel computations are carried out on a cluster with multiple
  nodes or on a multi-core processor.
}
\author{Marius Hofert and Martin Maechler.}
\seealso{
  \code{\link{subjob}()} for computing a subjob.  \code{\link{doCallWE}()}
  for the return value of \code{doOne()}.  \code{\link{.Random.seed}} for
  information about random number generators and seeds.
}
\examples{
 if(simsalapar:::doExtras()) { ## needs some CPU
   demo(robust.mean) # 512 simulations, differing block sizes, ...
 }
}
\keyword{utilities}
