% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorMat.R
\name{genCorMat}
\alias{genCorMat}
\title{Create a correlation matrix}
\usage{
genCorMat(nvars, cors = NULL)
}
\arguments{
\item{nvars}{number of rows and columns (i.e. number of variables) for correlation matrix}

\item{cors}{vector of correlations.}
}
\value{
correlation matrix of size nvars x nvars
}
\description{
Create a correlation matrix
}
\details{
If the vector cors is not specified, a random correlation matrix is generated with no assumptions.
If the vector is provided, it should be interpreted as the lower triangle of the correlation
matrix, and is specified by reading down the columns. For example, if CM is the correlation matrix and 
nvars = 3, then CM[2,1] = cors[1],  CM[3,1] = cors[2], and CM[3,2] = cors[3].
}
\examples{
genCorMat(3, c(.3, -.2, .1))
genCorMat(3)

genCorMat(5, c(.3, -.2, .1, .2, .5, .2, -.1, .3, .1, .2))
genCorMat(5)
}
