% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/herit_loci.R
\name{herit_loci}
\alias{herit_loci}
\title{Per-locus heritability contribution from allele frequency and causal coefficient}
\usage{
herit_loci(p_anc, causal_coeffs, causal_indexes = NULL, sigma_sq = 1)
}
\arguments{
\item{p_anc}{The ancestral allele frequency vector.}

\item{causal_coeffs}{The vector of causal coefficients.}

\item{causal_indexes}{The optional vector of causal indexes.
If \code{NULL} (default), \code{p_anc} and \code{causal_coeffs} are assumed to be for causal loci only (must be the same length).
If non-\code{NULL}, \code{causal_loci} is used to subset both \code{p_anc} and \code{causal_coeffs} as needed: if each of these vectors is longer than \code{causal_loci}, then it is subset; otherwise they must have equal lengths as \code{causal_loci} or an error is thrown.}

\item{sigma_sq}{The parametric variance factor of the trait (default 1).
This factor corresponds to the variance of an outbred individual.}
}
\value{
The vector of per-locus heritability contributions.
The sum of these values gives the overall heritability.
This value can be greater than one (or wrong, more generally) if \code{sigma_sq} is misspecified.
}
\description{
Calculates the vector of per-locus heritability values, with each causal locus \code{i} calculated as
\code{h_i^2 = 2 * p_i * ( 1 - p_i ) * beta_i^2 / sigma_sq},
where \code{p_i} is the ancestral allele frequency,
\code{beta_i} is the causal coefficient,
and \code{sigma_sq} is the trait variance scale.
These are all assumed to be true parameters (not estimated).
These per-locus heritabilities equal per-locus effect sizes divided by \code{sigma_sq}.
}
\examples{
# create toy random data
m_loci <- 10
# ancestral allele frequencies
p_anc <- runif( m_loci )
# causal loci
causal_coeffs <- rnorm( m_loci ) / m_loci
# resulting heritability contributions vector
herit_loci( p_anc, causal_coeffs )

}
\seealso{
\code{\link[=sim_trait]{sim_trait()}} generates random traits by drawing causal loci and their coefficients to fit a desired heritability.
\code{\link[=cov_trait]{cov_trait()}} calculates the covariance structure of the random traits.
}
