% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinaplot.R
\name{sinaplot}
\alias{sinaplot}
\title{sinaplot}
\usage{
sinaplot(x, groups, method = c("density", "counts"), scale = TRUE,
  bins = 50, bin_limit = 1, adjust = 3/4, maxwidth = 1, plot = TRUE,
  ylab = "", color = NULL, ...)
}
\arguments{
\item{x}{numeric vector of values to be plotted.}

\item{groups}{vector of \code{length(x)}.}

\item{method}{choose the method to spread the samples within the same
bin along the x-axis. Available methods: "density" and "counts".
See \code{Details}.}

\item{scale}{logical. When set to \code{TRUE} x-coordinate widths across all
groups are scaled based on the densiest are in the plot. Default: \code{TRUE}}

\item{bins}{number of bins to divide the y-axis into. Default: 50.}

\item{bin_limit}{If the samples within the same y-axis bin are more
than \code{bin_limit}, the samples's X coordinates will be adjusted.}

\item{adjust}{adjusts the bandwidth of the density kernel when
\code{method == "density"} (see \code{\link[stats]{density}}).}

\item{maxwidth}{Control the maximum width the points can spread into. Values
between 0 and 1.}

\item{plot}{logical. When \code{TRUE} the sinaplot is produced, otherwise the
function returns the new sample coordinates. Default: \code{TRUE}}

\item{ylab}{Y axis label}

\item{color}{vector of \code{length(unique(groups))}. Controls the sample
color of each group.}

\item{...}{arguments to be passed to \code{\link[graphics]{plot}}.}
}
\value{
If \code{plot == FALSE} the function returns a data.frame with the
following columns:

\item{x}{discrete x-coordinates, split by group}
\item{y}{input values}
\item{group}{input groups}
\item{bin_counts}{number of samples per bin per group}
\item{scaled}{final x-coordinates, adjusted by sinaplot}
}
\description{
The SinaPlot is a data visualization chart suitable for plotting
any single variable in a multiclass dataset. It is an enhanced jitter strip
chart, where the width of the jitter is controlled by the density
distribution of the data within each class.
}
\details{
There are two available ways to define the x-axis borders for the
samples to spread within:
\itemize{
 \item{\code{method = "density"}

  A density kernel is estimated along the y-axis for every sample group. The
  borders are then defined by the density curve. Tuning parameter
  \code{adjust} can be used to control the density bandwidth in the same way
  it is used in \code{\link[stats]{density}}. }

 \item{\code{method = "counts"}:

 The borders are defined by the number of samples that 'live' in the same
 bin and the parameter \code{maxwidth} in the following fashion:

 \code{xBorder = nsamples * maxwidth}

  }
}
}
\examples{

x <- c(rnorm(200, 4, 1), rnorm(200, 5, 2), rnorm(400, 6, 1.5))
groups <- c(rep("Cond1", 200), rep("Cond2", 200), rep("Cond3", 400))

sinaplot(x, groups)
sinaplot(x, groups, scale = FALSE)
sinaplot(x, groups, scale = FALSE, adjust = 1/6)
sinaplot(x, groups, scale = FALSE, adjust = 3)

#blood
data("blood", package = "sinaplot")

old.mar <- par()$mar
par(mar = c(9,4,4,2) + 0.1)

sinaplot(blood$value, blood$type)
sinaplot(blood$value, blood$type, method = "counts")
sinaplot(blood$value, blood$type, method = "counts", scale = FALSE)

par(mar = old.mar)

}

