% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TD.R
\name{TD}
\alias{TD}
\title{Test of Deficit}
\usage{
TD(
  case,
  controls,
  sd = NULL,
  sample_size = NULL,
  alternative = c("less", "greater", "two.sided"),
  conf_int = TRUE,
  conf_level = 0.95,
  conf_int_spec = 0.01,
  na.rm = FALSE
)
}
\arguments{
\item{case}{Case observation, can only be a single value.}

\item{controls}{Numeric vector of observations from the control sample. If
single value, treated as mean.}

\item{sd}{If input of controls is single value, the standard
deviation of the sample must be given as well.}

\item{sample_size}{If input of controls is single value, the size of the
sample must be gven as well.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"less"} (default), \code{"greater"} or
\code{"two.sided"}. You can specify just the initial letter.}

\item{conf_int}{Initiates a search algorithm for finding confidence
intervals. Defaults to \code{TRUE}, set to \code{FALSE} for faster
calculation (e.g. for simulations).}

\item{conf_level}{Level of confidence for intervals, defaults to 95\%.}

\item{conf_int_spec}{The size of iterative steps for calculating confidence
intervals. Smaller values gives more precise intervals but takes longer to
calculate. Defaults to a specificity of 0.01.}

\item{na.rm}{Remove \code{NA}s from controls.}
}
\value{
A list of class \code{"htest"} containing the following components:
\tabular{llll}{
\code{statistic}   \tab the value of the t-statistic.\cr\cr  \code{parameter}
\tab the degrees of freedom for the t-statistic.\cr\cr \code{p.value}    \tab
the p-value for the test.\cr\cr \code{estimate}    \tab estimated
standardised difference (Z-CC) and point estimate of p-value. \cr\cr
\code{null.value}   \tab the value of the difference under the null
hypothesis.\cr\cr \code{interval}     \tab named numerical vector containing
level of confidence and confidence intervals for both Z-CC and p-value. \cr\cr
\code{desc}     \tab named numerical containing descriptive statistics: mean
and standard deviations of controls as well as sample size and standard error
used in the t-formula. \cr\cr \code{alternative}     \tab a character string
describing the alternative hypothesis.\cr\cr \code{method} \tab a character
string indicating what type of t-test was performed.\cr\cr \code{data.name}
\tab a character string giving the name(s) of the data as well as
summaries. }
}
\description{
Crawford and Howell's (1998) modified t-test. Takes a single observation and
compares it to a distribution estimated by a control sample. Calculates
standardised difference between the case score and the mean of the controls
and proportions falling above or below the case score, as well as associated
confidence intervals.
}
\details{
Returns the point estimate of the standardised difference
between the case score and the mean of the controls and the point estimate
of the p-value (i.e. the percentage of the population that would be
expected to obtain a lower or higher score, depending on the alternative
hypothesis).
}
\section{Note of caution}{

Calculating the confidence intervals relies on finding non-centrality
parameters for non-central t-distributions. Depending on the degrees of
freedom, the confidence level and the effect size exact accuracy from the
\code{stats::qt()} function used can not be guaranteed. However, the
approximations should be good enough for most cases.
See \url{https://stat.ethz.ch/pipermail/r-help/2008-June/164843.html}.
}

\examples{
TD(case = -2, controls = 0, sd = 1, sample_size = 20)

TD(case = size_weight_illusion[1, "V_SWI"],
   controls = size_weight_illusion[-1, "V_SWI"], alternative = "l")

}
\references{
Crawford, J. R., & Howell, D. C. (1998). Comparing an Individual's Test Score
Against Norms Derived from Small Samples. \emph{The Clinical Neuropsychologist,
12}(4), 482 - 486. \doi{10.1076/clin.12.4.482.7241}

Crawford, J. R., & Garthwaite, P. H. (2002). Investigation of the single case
in neuropsychology: Confidence limits on the abnormality of test scores and
test score differences. \emph{Neuropsychologia, 40}(8), 1196-1208.
\doi{10.1016/S0028-3932(01)00224-X}
}
