% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{plot_gene_haystack}
\alias{plot_gene_haystack}
\alias{plot_gene_haystack.matrix}
\alias{plot_gene_haystack.data.frame}
\alias{plot_gene_haystack.SingleCellExperiment}
\alias{plot_gene_haystack.Seurat}
\title{Visualizing the detection/expression of a gene in a 2D plot}
\usage{
plot_gene_haystack(x, ...)

\method{plot_gene_haystack}{matrix}(x, dim1 = 1, dim2 = 2, ...)

\method{plot_gene_haystack}{data.frame}(x, dim1 = 1, dim2 = 2, ...)

\method{plot_gene_haystack}{SingleCellExperiment}(
  x,
  dim1 = 1,
  dim2 = 2,
  assay = "counts",
  coord = "TSNE",
  ...
)

\method{plot_gene_haystack}{Seurat}(
  x,
  dim1 = 1,
  dim2 = 2,
  assay = "RNA",
  slot = "data",
  coord = "tsne",
  ...
)
}
\arguments{
\item{x}{a matrix or other object from which coordinates of cells can be extracted.}

\item{...}{further paramters passed to plot_gene_haystack_raw().}

\item{dim1}{column index or name of matrix for x-axis coordinates.}

\item{dim2}{column index or name of matrix for y-axis coordinates.}

\item{assay}{name of assay data for Seurat method.}

\item{coord}{name of coordinates slot for specific methods.}

\item{slot}{name of slot for assay data for Seurat method.}
}
\description{
Visualizing the detection/expression of a gene in a 2D plot
}
