% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.predict}
\alias{sirus.predict}
\title{Predict}
\usage{
sirus.predict(sirus.m, data.test)
}
\arguments{
\item{sirus.m}{A SIRUS model generated by sirus.fit.}

\item{data.test}{Testing data (dataframe of new observations).}
}
\value{
Predictions. A vector of the predicted probability of each new observation to be of class 1.
}
\description{
Predictions of a SIRUS model for new observations.
}
\examples{
## load sirus
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

#' ## fit sirus
sirus.m <- sirus.fit(data, y)

## predict
predictions <- sirus.predict(sirus.m, data)

}
