% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_system.R
\name{addEdge}
\alias{addEdge}
\title{Adds an edge in the in silico system's regulatory network.}
\usage{
addEdge(insilicosystem, regID, tarID, regsign = NULL, kinetics = list())
}
\arguments{
\item{insilicosystem}{The in silico system (see \code{\link{createInSilicoSystem}}).}

\item{regID}{Character. The ID of the regulator gene or complex.}

\item{tarID}{Character. The ID of the target gene.}

\item{regsign}{The sign of the regulation: either "1" (positive regulation) or "-1" (negative regulation). If none provided,
will be randomly chosen according to the parameter \code{TC.pos.p}, \code{TL.pos.p} or \code{PTM.pos.p} (depending on the type
of regulation - regulation of RNA or protein decay can only be negative) provided in sysargs (see \code{\link{insilicosystemargs}}).}

\item{kinetics}{Optional: named list of kinetics parameters of the reaction. If none provided,
will be randomly chosen according to the parameters \code{[name of the param]_samplingfct} provided in sysargs (see \code{\link{insilicosystemargs}}). The parameters
to provide depend on the type of regulation (i.e. parameter \code{TargetReaction} of the regulator):
\itemize{
\item TargetReaction = "TC": the parameters to specify are "TCbindingrate", "TCunbindingrate" and "TCfoldchange";
\item TargetReaction = "TL": the parameters to specify are "TLbindingrate", "TLunbindingrate" and "TLfoldchange";
\item TargetReaction = "RD": the parameter to specify is "RDregrate";
\item TargetReaction = "PD": the parameter to specify is "PDregrate";
\item TargetReaction = "PTM": the parameter to specify is "PTMregrate".
}}
}
\value{
The modified in silico system.
}
\description{
Adds an edge in the in silico system's regulatory network between specified genes.
}
\details{
It must be noted that the type of regulation depends on the biological function of the regulator gene/complex
(parameter \code{TargetReaction}).
}
\examples{
\donttest{
## creates a system with no regulation
mysystem = createInSilicoSystem(G = 10, PC.p = 1, PC.TC.p = 1, empty = TRUE)
mysystem$edg
mysystem2 = addEdge(mysystem, 1, 2, regsign = "1",
 kinetics = c("TCbindingrate"= 0.01, "TCunbindingrate" = 0.1, "TCfoldchange" = 10))
## check all existing interactions in the system (no kinetic parameters)
mysystem2$edg
## check the interactions targeting transcription, with kinetic parameters
mysystem2$mosystem$TCRN_edg

## creates a system with no regulation
mysystem = createInSilicoSystem(G = 5, PC.p = 1, PC.PD.p = 1, empty = TRUE)
mysystem$edg
mysystem2 = addEdge(mysystem, 1, 2)
## check all existing interactions in the system (no kinetic parameters)
mysystem2$edg
## check the interactions targeting protein decay, with kinetic parameters
mysystem2$mosystem$PDRN_edg
}
}
