% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cluster.R
\name{.sits_cluster_dendrogram}
\alias{.sits_cluster_dendrogram}
\title{Compute a dendrogram using hierarchical clustering}
\usage{
.sits_cluster_dendrogram(
  samples,
  bands,
  dist_method = "dtw_basic",
  linkage = "ward.D2",
  ...
)
}
\arguments{
\item{samples}{Time series data and metadata
to be used to generate the dendrogram.}

\item{bands}{Vector of bands to be clustered.}

\item{dist_method}{One of the supported distance
from proxy's dist, e.g. \code{TWDTW}.}

\item{linkage}{Agglomeration method to be used.
Can be any `hclust` method (see `hclust`).
Default is 'ward.D2'.}

\item{...}{Any additional parameters to be passed
to dtwclust::tsclust() function.}
}
\value{
Full dendrogram tree for data analysis.
}
\description{
Cluster time series in hierarchical mode.
Hierarchical clustering, as its name suggests,
is an algorithm that tries to create a hierarchy of groups in which,
as the level in the hierarchy increases, clusters are created by merging
the clusters from the next lower level, producing
an ordered sequence of groupings. The similarity measure used to
group time series in a cluster is the dtw metric.
The procedure is deterministic, so it will always give the same
result for a chosen set of similarity measures
(see \code{\link[dtwclust]{tsclust}}).
}
\references{
`dtwclust` package (https://CRAN.R-project.org/package=dtwclust)
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
\keyword{internal}
