% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_data.R
\name{sits_get_data.sits}
\alias{sits_get_data.sits}
\title{Get time series using sits objects}
\usage{
\method{sits_get_data}{sits}(
  cube,
  samples,
  ...,
  bands = NULL,
  crs = "EPSG:4326",
  impute_fn = impute_linear(),
  multicores = 2L,
  progress = FALSE
)
}
\arguments{
\item{cube}{Data cube from where data is to be retrieved.
(tibble of class "raster_cube").}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits", an "sf" object,
the name of a shapefile or csv file, or
a data.frame with columns "longitude" and "latitude".}

\item{...}{Specific parameters for specific cases.}

\item{bands}{Bands to be retrieved - optional.}

\item{crs}{A character with the samples crs.
Default is "EPSG:4326".}

\item{impute_fn}{Imputation function to remove NA.}

\item{multicores}{Number of threads to process the time series
(integer, with min = 1 and max = 2048).}

\item{progress}{Logical: show progress bar?}
}
\value{
A tibble of class "sits" with set of time series
<longitude, latitude, start_date, end_date, label>.
}
\description{
Retrieve a set of time series from a data cube and
and put the result in a \code{sits tibble}. The \code{samples}
parameter should be a valid \code{sits tibble} which
which contains columns
\code{longitude}, \code{latitude},
\code{start_date}, \code{end_date} and \code{label} for each sample.
}
