% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_fac}
\alias{to_fac}
\title{Convert variable into factor and keep value labels}
\usage{
to_fac(x)
}
\arguments{
\item{x}{A (numeric or atomic) variable.}
}
\value{
A factor variable, including variable and value labels.
}
\description{
This function converts a variable into a factor, but keeps
               variable and value labels, if these are attached as attributes
               to the variale \code{var}. See examples.
}
\note{
This function only works with vectors that have value and variable
       labels attached. This is automatically done by importing SPSS data sets
       with the \code{\link{read_spss}} function and can manually be applied
       with the \code{\link{set_val_labels}} and \code{\link{set_var_labels}}
       functions.
}
\examples{
\dontrun{
data(efc)
# normal factor conversion, loses value attributes
efc$e42dep <- as.factor(efc$e42dep)
sjt.frq(efc$e42dep)

data(efc)
# factor conversion, which keeps value attributes
efc$e42dep <- to_fac(efc$e42dep)
sjt.frq(efc$e42dep)}
}
\seealso{
\itemize{
           \item \code{\link{to_value}}
           \item \code{\link{to_label}}
           \item \code{\link{get_val_labels}}
           \item \code{\link{get_var_labels}}
           \item \code{\link{read_spss}}
           \item \code{\link{write_spss}}
           }
}

