% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_models.R
\name{plot_models}
\alias{plot_models}
\alias{sjp.lmm}
\alias{sjp.glmm}
\title{Forest plot of multiple regression models}
\usage{
plot_models(..., exponentiate, std.est = NULL, rm.terms = NULL,
  title = NULL, m.labels = NULL, legend.title = "Dependent Variables",
  legend.pval.title = "p-level", axis.labels = NULL, axis.title = NULL,
  axis.lim = NULL, wrap.title = 50, wrap.labels = 25,
  wrap.legend.title = 20, grid.breaks = NULL, geom.size = 3,
  geom.spacing = 0.4, geom.colors = "Set1", show.values = FALSE,
  show.legend = TRUE, show.intercept = FALSE, show.p = TRUE,
  p.shape = FALSE, vline.type = 2, vline.color = "grey70", digits = 2,
  facet.grid = FALSE)

sjp.lmm(...)

sjp.glmm(...)
}
\arguments{
\item{...}{One or more regression models, including glm's or mixed models.
May also be a \code{list} with fitted models. See 'Examples'.}

\item{exponentiate}{Logical, if \code{TRUE} and models inherit from generalized
linear models, estimates will be exponentiated (e.g., log-odds will
be displayed as odds ratios). By default, \code{exponentiate} will
automatically be set to \code{FALSE} or \code{TRUE}, depending on
the class of \code{fit}.}

\item{std.est}{For linear models, choose whether standardized coefficients should
be used for plotting. Default is no standardization.
\describe{
  \item{\code{NULL}}{(default) no standardization, returns original estimates.}
  \item{\code{"std"}}{standardized beta values.}
  \item{\code{"std2"}}{standardized beta values, however, standardization is done by rescaling estimates by dividing them by two sd (see \code{\link[sjstats]{std_beta}}).}
}}

\item{rm.terms}{Character vector with names that indicate which terms should
be removed from the plot. \code{rm.terms = "t_name"} would remove the
term \emph{t_name}. Default is \code{NULL}, i.e. all terms are
used.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{m.labels}{Character vector, used to indicate the different models
in the plot's legend. If not specified, the labels of the dependent
variables for each model are used.}

\item{legend.title}{Character vector, used as title for the plot legend. Note that
only some plot types have legends (e.g. \code{type = "pred"} or when
grouping estimates with \code{group.estimates}).}

\item{legend.pval.title}{Character vector, used as title of the plot legend that
indicates the p-values. Default is \code{"p-level"}. Only applies if
\code{p.shape = TRUE}.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{axis.title}{Character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis.
If not specified, a default labelling  is chosen. To set multiple
axis titles (e.g. with \code{type = "eff"} for many predictors),
\code{axis.title} must be a character vector of same length of plots
that are printed. In this case, each plot gets an own axis title
(applying, for instance, to the y-axis for \code{type = "eff"}).
\strong{Note:} Some plot types do not support this argument. In such
cases, use the return value and add axis titles manually with
\code{\link[ggplot2]{labs}}, e.g.: \code{$plot.list[[1]] + labs(x = ...)}}

\item{axis.lim}{Numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or
\code{type = "slope"} in \code{\link{sjp.glm}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.spacing}{Numeric, spacing between the dots and error bars of the
plotted fitted models. Default is 0.3.}

\item{geom.colors}{User defined color palette for geoms. If \code{group.estimates}
is \emph{not} specified, must either be vector with two color values or a specific
color palette code (see 'Details' in \code{\link{sjp.grpfrq}}). Else, if
\code{group.estimates} is specified, \code{geom.colors} must be a vector
of same length as groups. See 'Examples'.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.intercept}{Logical, if \code{TRUE}, the intercept of the fitted
model is also plotted. Default is \code{FALSE}. If \code{exponentiate = TRUE},
please note that due to exponential transformation of estimates, the
intercept in some cases is non-finite and the plot can not be created.}

\item{show.p}{Logical, adds significance levels to values, or value and
variable labels.}

\item{p.shape}{Logical, if \code{TRUE}, significant levels are distinguished by
different point shapes and a related legend is plotted. Default
is \code{FALSE}.}

\item{vline.type}{Linetype of the vertical "zero point" line. Default is \code{2} (dashed line).}

\item{vline.color}{Color of the vertical "zero point" line. Default value is \code{"grey70"}.}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{facet.grid}{\code{TRUE} to arrange the lay out of of multiple plots
in a grid of an integrated single plot. This argument calls
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}
to arrange plots. Use \code{\link{plot_grid}} to plot multiple plot-objects
as an arranged grid with \code{\link[gridExtra]{grid.arrange}}.}
}
\value{
A ggplot-object.
}
\description{
Plot and compare regression coefficients with confidence
               intervals of multiple regression models in one plot.
}
\examples{
library(sjmisc)
data(efc)

# fit three models
fit1 <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
fit2 <- lm(neg_c_7 ~ c160age + c12hour + c161sex + c172code, data = efc)
fit3 <- lm(tot_sc_e ~ c160age + c12hour + c161sex + c172code, data = efc)

# plot multiple models
plot_models(fit1, fit2, fit3, facet.grid = TRUE)

# plot multiple models with legend labels and
# point shapes instead of value labels
plot_models(
  fit1, fit2, fit3,
  axis.labels = c(
    "Carer's Age", "Hours of Care", "Carer's Sex", "Educational Status"
  ),
  m.labels = c("Barthel Index", "Negative Impact", "Services used"),
  show.values = FALSE, show.p = FALSE, p.shape = TRUE
)

# plot multiple models from nested lists argument
all.models <- list()
all.models[[1]] <- fit1
all.models[[2]] <- fit2
all.models[[3]] <- fit3

plot_models(all.models)

# plot multiple models with different predictors (stepwise inclusion),
# standardized estimates
fit1 <- lm(mpg ~ wt + cyl + disp + gear, data = mtcars)
fit2 <- update(fit1, . ~ . + hp)
fit3 <- update(fit2, . ~ . + am)

plot_models(fit1, fit2, fit3, std.est = "std2")

}
