% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_model.R
\name{tab_model}
\alias{tab_model}
\title{Print regression models as HTML table}
\usage{
tab_model(
  ...,
  transform,
  show.intercept = TRUE,
  show.est = TRUE,
  show.ci = 0.95,
  show.ci50 = FALSE,
  show.se = NULL,
  show.std = NULL,
  show.p = TRUE,
  show.stat = FALSE,
  show.df = FALSE,
  show.zeroinf = TRUE,
  show.r2 = TRUE,
  show.icc = TRUE,
  show.re.var = TRUE,
  show.ngroups = TRUE,
  show.fstat = FALSE,
  show.aic = FALSE,
  show.aicc = FALSE,
  show.dev = FALSE,
  show.loglik = FALSE,
  show.obs = TRUE,
  show.reflvl = FALSE,
  terms = NULL,
  rm.terms = NULL,
  order.terms = NULL,
  title = NULL,
  pred.labels = NULL,
  dv.labels = NULL,
  wrap.labels = 25,
  bootstrap = FALSE,
  iterations = 1000,
  seed = NULL,
  vcov.fun = NULL,
  vcov.type = c("HC3", "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5"),
  vcov.args = NULL,
  string.pred = "Predictors",
  string.est = "Estimate",
  string.std = "std. Beta",
  string.ci = "CI",
  string.se = "std. Error",
  string.std_se = "standardized std. Error",
  string.std_ci = "standardized CI",
  string.p = "p",
  string.df = "df",
  string.stat = "Statistic",
  string.resp = "Response",
  string.intercept = "(Intercept)",
  strings = NULL,
  ci.hyphen = "&nbsp;&ndash;&nbsp;",
  minus.sign = "&#45;",
  collapse.ci = FALSE,
  collapse.se = FALSE,
  linebreak = TRUE,
  col.order = c("est", "se", "std.est", "std.se", "ci", "std.ci", "ci.inner",
    "ci.outer", "stat", "p", "df", "response.level"),
  digits = 2,
  digits.p = 3,
  emph.p = TRUE,
  p.val = c("wald", "kr"),
  p.style = c("numeric", "asterisk", "both"),
  p.threshold = c(0.05, 0.01, 0.001),
  case = "parsed",
  auto.label = TRUE,
  prefix.labels = c("none", "varname", "label"),
  bpe = "median",
  CSS = css_theme("regression"),
  file = NULL,
  use.viewer = TRUE
)
}
\arguments{
\item{...}{One or more regression models, including glm's or mixed models.
May also be a \code{list} with fitted models. See 'Examples'.}

\item{transform}{A character vector, naming a function that will be applied
on estimates and confidence intervals. By default, \code{transform} will
automatically use \code{"exp"} as transformation for applicable classes of
\code{model} (e.g. logistic or poisson regression). Estimates of linear
models remain untransformed. Use \code{NULL} if you want the raw,
non-transformed estimates.}

\item{show.intercept}{Logical, if \code{TRUE}, the intercepts are printed.}

\item{show.est}{Logical, if \code{TRUE}, the estimates are printed.}

\item{show.ci}{Either logical, and if \code{TRUE}, the confidence intervals
is printed to the table; if \code{FALSE}, confidence intervals are
omitted. Or numeric, between 0 and 1, indicating the range of the
confidence intervals.}

\item{show.ci50}{Logical, if \code{TRUE}, for Bayesian models, a second
credible interval is added to the table output.}

\item{show.se}{Logical, if \code{TRUE}, the standard errors are
also printed. If robust standard errors are required, use arguments
\code{vcov.fun}, \code{vcov.type} and \code{vcov.args} (see
\code{\link[sjstats]{robust}} for details).}

\item{show.std}{Indicates whether standardized beta-coefficients should
also printed, and if yes, which type of standardization is done.
See 'Details'.}

\item{show.p}{Logical, if \code{TRUE}, p-values are also printed.}

\item{show.stat}{Logical, if \code{TRUE}, the coefficients' test statistic
is also printed.}

\item{show.df}{Logical, if \code{TRUE} and \code{p.val = "kr"}, the p-values
for linear mixed models are based on df with Kenward-Rogers approximation.
These df-values are printed. See \code{\link[sjstats]{p_value}} for details.}

\item{show.zeroinf}{Logical, if \code{TRUE} and model has a zero-inflated
model part, this is also printed to the table.}

\item{show.r2}{Logical, if \code{TRUE}, the r-squared value is also printed.
Depending on the model, these might be pseudo-r-squared values, or Bayesian
r-squared etc. See \code{\link[performance]{r2}} for details.}

\item{show.icc}{Logical, if \code{TRUE}, prints the intraclass correlation
coefficient for mixed models. See \code{\link[performance]{icc}} for details.}

\item{show.re.var}{Logical, if \code{TRUE}, prints the random effect variances
for mixed models. See \code{\link[insight]{get_variance}} for details.}

\item{show.ngroups}{Logical, if \code{TRUE}, shows number of random effects groups
for mixed models.}

\item{show.fstat}{Logical, if \code{TRUE}, the F-statistics for each model is
printed in the table summary. This option is not supported by all model types.}

\item{show.aic}{Logical, if \code{TRUE}, the AIC value for each model is printed
in the table summary.}

\item{show.aicc}{Logical, if \code{TRUE}, the second-order AIC value for each model
is printed in the table summary.}

\item{show.dev}{Logical, if \code{TRUE}, shows the deviance of the model.}

\item{show.loglik}{Logical, if \code{TRUE}, shows the log-Likelihood of the model.}

\item{show.obs}{Logical, if \code{TRUE}, the number of observations per model is
printed in the table summary.}

\item{show.reflvl}{Logical, if \code{TRUE}, an additional row is inserted to
the table before each predictor of type \code{\link{factor}}, which will
indicate the reference level of the related factor.}

\item{terms}{Character vector with names of those terms (variables) that should
be printed in the table. All other terms are removed from the output. If
\code{NULL}, all terms are printed. Note that the term names must match
the names of the model's coefficients. For factors, this means that
the variable name is suffixed with the related factor level, and each
category counts as one term. E.g. \code{rm.terms = "t_name [2,3]"}
would remove the terms \code{"t_name2"} and \code{"t_name3"} (assuming
that the variable \code{t_name} is categorical and has at least
the factor levels \code{2} and \code{3}). Another example for the
\emph{iris}-dataset: \code{terms = "Species"} would not work, instead
use \code{terms = "Species [versicolor,virginica]"}.}

\item{rm.terms}{Character vector with names that indicate which terms should
be removed from the output Counterpart to \code{terms}. \code{rm.terms =
"t_name"} would remove the term \emph{t_name}. Default is \code{NULL}, i.e.
all terms are used. For factors, levels that should be removed from the plot
need to be explicitely indicated in square brackets, and match the model's
coefficient names, e.g. \code{rm.terms = "t_name [2,3]"} would remove the terms
\code{"t_name2"} and \code{"t_name3"} (assuming that the variable \code{t_name}
was categorical and has at least the factor levels \code{2} and \code{3}).}

\item{order.terms}{Numeric vector, indicating in which order the coefficients
should be plotted. See examples in
\href{https://strengejacke.github.io/sjPlot/articles/plot_model_estimates.html}{this package-vignette}.}

\item{title}{String, will be used as table caption.}

\item{pred.labels}{Character vector with labels of predictor variables.
If not \code{NULL}, \code{pred.labels} will be used in the first
table column with the predictors' names. By default, if \code{auto.label = TRUE}
and \href{https://strengejacke.github.io/sjlabelled/articles/intro_sjlabelled.html}{data is labelled},
\code{\link[sjlabelled]{get_term_labels}} is called to retrieve the labels
of the coefficients, which will be used as predictor labels. If data is
not labelled, \href{https://easystats.github.io/parameters/reference/format_parameters.html}{format_parameters()}
is used to create pretty labels. If \code{pred.labels = ""} or \code{auto.label = FALSE}, the raw
variable names as used in the model formula are used as predictor
labels. If \code{pred.labels} is a named vector, predictor labels (by
default, the names of the model's coefficients) will be matched with the
names of \code{pred.labels}. This ensures that labels always match the
related predictor in the table, no matter in which way the predictors
are sorted. See 'Examples'.}

\item{dv.labels}{Character vector with labels of dependent variables of all
fitted models. See 'Examples'.}

\item{wrap.labels}{Numeric, determines how many chars of the value, variable
or axis labels are displayed in one line and when a line break is inserted.}

\item{bootstrap}{Logical, if \code{TRUE}, returns bootstrapped estimates..}

\item{iterations}{Numeric, number of bootsrap iterations (default is 1000).}

\item{seed}{Numeric, the number of the seed to replicate bootstrapped estimates. If \code{NULL}, uses random seed.}

\item{vcov.fun}{Character vector, indicating the name of the \code{vcov*()}-function
from the \pkg{sandwich}-package, e.g. \code{vcov.fun = "vcovCL"}, if robust
standard errors are required.}

\item{vcov.type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich]{vcovHC}}
for details).}

\item{vcov.args}{List of named vectors, used as additional arguments that
are passed down to \code{vcov.fun}.}

\item{string.pred}{Character vector,used as headline for the predictor column.
Default is \code{"Predictors"}.}

\item{string.est}{Character vector, used for the column heading of coefficients.
Default is based on the response scale, e.g. for logistic regression models,
\code{"Odds Ratios"} will be chosen, while for Poisson models it is
\code{"Incidence Rate Ratios"} etc. Default if not specified is \code{"Estimate"}.}

\item{string.std}{Character vector, used for the column heading of standardized beta coefficients. Default is \code{"std. Beta"}.}

\item{string.ci}{Character vector, used for the column heading of confidence interval values. Default is \code{"CI"}.}

\item{string.se}{Character vector, used for the column heading of standard error values. Default is \code{"std. Error"}.}

\item{string.std_se}{Character vector, used for the column heading of standard error of standardized coefficients. Default is \code{"standardized std. Error"}.}

\item{string.std_ci}{Character vector, used for the column heading of confidence intervals of standardized coefficients. Default is \code{"standardized std. Error"}.}

\item{string.p}{Character vector, used for the column heading of p values. Default is \code{"p"}.}

\item{string.df}{Character vector, used for the column heading of degrees of freedom. Default is \code{"df"}.}

\item{string.stat}{Character vector, used for the test statistic. Default is \code{"Statistic"}.}

\item{string.resp}{Character vector, used for the column heading of of the response level for multinominal or categorical models. Default is \code{"Response"}.}

\item{string.intercept}{Character vector, used as name for the intercept parameter. Default is \code{"(Intercept)"}.}

\item{strings}{Named character vector, as alternative to arguments like \code{string.ci}
or \code{string.p} etc. The name (lhs) must be one of the string-indicator from
the forementioned arguments, while the value (rhs) is the string that is used
as column heading. E.g., \code{strings = c(ci = "Conf.Int.", se = "std. Err")}
would be equivalent to setting \code{string.ci = "Conf.Int.", string.se = "std. Err"}.}

\item{ci.hyphen}{Character vector, indicating the hyphen for confidence interval range.
May be an HTML entity. See 'Examples'.}

\item{minus.sign}{string, indicating the minus sign for negative numbers.
May be an HTML entity. See 'Examples'.}

\item{collapse.ci}{Logical, if \code{FALSE}, the CI values are shown in
a separate table column.}

\item{collapse.se}{Logical, if \code{FALSE}, the SE values are shown in
a separate table column.}

\item{linebreak}{Logical, if \code{TRUE} and \code{collapse.ci = FALSE} or
\code{collapse.se = FALSE}, inserts a line break between estimate and
CI resp. SE values. If \code{FALSE}, values are printed in the same line
as estimate values.}

\item{col.order}{Character vector, indicating which columns should be printed
and in which order. Column names that are excluded from \code{col.order}
are not shown in the table output. However, column names that are included,
are only shown in the table when the related argument (like \code{show.est}
for \code{"estimate"}) is set to \code{TRUE} or another valid value.
Table columns are printed in the order as they appear in \code{col.order}.}

\item{digits}{Amount of decimals for estimates}

\item{digits.p}{Amount of decimals for p-values}

\item{emph.p}{Logical, if \code{TRUE}, significant p-values are shown bold faced.}

\item{p.val}{Character, for mixed models, indicates how p-values are computed.
Use \code{p.val = "wald"} for a faster, but less precise computation. For
\code{p.val = "kr"}, computation of p-values is based on conditional F-tests
with Kenward-Roger approximation for the degrees of freedom, using the
\pkg{pbkrtest}-package. In this case, use \code{show.df = TRUE} to show
the approximated degrees of freedom for each coefficient.}

\item{p.style}{Character, indicating if p-values should be printed as
numeric value (\code{"numeric"}), as asterisks (\code{"asterisk"})
or both (\code{"both"}). May be abbreviated.}

\item{p.threshold}{Numeric vector of length 3, indicating the treshold for
annotating p-values with asterisks. Only applies if
\code{p.style = "asterisk"}.}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{\link[snakecase]{to_any_case}} for more
details on this argument. By default, if \code{case} is not specified,
it will be set to \code{"parsed"}, unless \code{prefix.labels} is not
\code{"none"}. If \code{prefix.labels} is either \code{"label"} (or
\code{"l"}) or \code{"varname"} (or \code{"v"}) and \code{case} is not
specified, it will be set to \code{NULL} - this is a more convenient
default when prefixing labels.}

\item{auto.label}{Logical, if \code{TRUE} (the default),
 and \href{https://strengejacke.github.io/sjlabelled/articles/intro_sjlabelled.html}{data is labelled},
 \code{\link[sjlabelled]{get_term_labels}} is called to retrieve the labels
 of the coefficients, which will be used as predictor labels. If data is
 not labelled, \href{https://easystats.github.io/parameters/reference/format_parameters.html}{format_parameters()}
 is used to create pretty labels. If \code{auto.label = FALSE},
original variable names and value labels (factor levels) are used.}

\item{prefix.labels}{Indicates whether the value labels of categorical variables
should be prefixed, e.g. with the variable name or variable label. See
argument \code{prefix} in \code{\link[sjlabelled]{get_term_labels}} for
details.}

\item{bpe}{For \strong{Stan}-models (fitted with the \pkg{rstanarm}- or
\pkg{brms}-package), the Bayesian point estimate is, by default, the median
of the posterior distribution. Use \code{bpe} to define other functions to
calculate the Bayesian point estimate. \code{bpe} needs to be a character
naming the specific function, which is passed to the \code{fun}-argument in
\code{\link[sjmisc]{typical_value}}. So, \code{bpe = "mean"} would
calculate the mean value of the posterior distribution.}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions,
according to the \href{http://www.w3.org/Style/CSS/}{official CSS syntax}.
See 'Details' or \href{https://strengejacke.github.io/sjPlot/articles/table_css.html}{this package-vignette}.}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's
viewer pane. If \code{FALSE} or no viewer available, the HTML table is
opened in a web browser.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{page.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
\code{tab_model()} creates HTML tables from regression models.
}
\details{
\strong{Standardized Estimates}
   \cr \cr
   Concerning the \code{show.std} argument, \code{show.std = "std"}
   will print normal standardized estimates. For \code{show.std = "std2"},
   however, standardization of estimates follows
   \href{http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf}{Gelman's (2008)}
   suggestion, rescaling the estimates by dividing them by two standard
   deviations instead of just one. Resulting coefficients are then
   directly comparable for untransformed binary predictors.
   For backward compatibility reasons, \code{show.std} also may be
   a logical value; if \code{TRUE}, normal standardized estimates are
   printed (same effect as \code{show.std = "std"}). Use
   \code{show.std = NULL} (default) or \code{show.std = FALSE},
   if standardized estimats should not be printed.
   \cr \cr
   \strong{How do I use \code{CSS}-argument?}
   \cr \cr
   With the \code{CSS}-argument, the visual appearance of the tables
   can be modified. To get an overview of all style-sheet-classnames
   that are used in this function, see return value \code{page.style} for details.
   Arguments for this list have following syntax:
   \enumerate{
     \item the class-names with \code{"css."}-prefix as argument name and
     \item each style-definition must end with a semicolon
   }
   You can add style information to the default styles by using a + (plus-sign) as
   initial character for the argument attributes. Examples:
   \itemize{
     \item \code{css.table = 'border:2px solid red;'} for a solid 2-pixel table border in red.
     \item \code{css.summary = 'font-weight:bold;'} for a bold fontweight in the summary row.
     \item \code{css.lasttablerow = 'border-bottom: 1px dotted blue;'} for a blue dotted border of the last table row.
     \item \code{css.colnames = '+color:green'} to add green color formatting to column names.
     \item \code{css.arc = 'color:blue;'} for a blue text color each 2nd row.
     \item \code{css.caption = '+color:red;'} to add red font-color to the default table caption style.
   }
}
\note{
The HTML tables can either be saved as file and manually opened (use argument \code{file}) or
        they can be saved as temporary files and will be displayed in the RStudio Viewer pane (if working with RStudio)
        or opened with the default web browser. Displaying resp. opening a temporary file is the
        default behaviour (i.e. \code{file = NULL}).
        \cr \cr
        Examples are shown in these three vignettes:
        \href{https://strengejacke.github.io/sjPlot/articles/tab_model_estimates.html}{Summary of Regression Models as HTML Table},
        \href{https://strengejacke.github.io/sjPlot/articles/tab_mixed.html}{Summary of Mixed Models as HTML Table} and
        \href{https://strengejacke.github.io/sjPlot/articles/tab_bayes.html}{Summary of Bayesian Models as HTML Table}.
}
