% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{to_value}
\alias{to_value}
\title{Converts factors to numeric variables}
\usage{
to_value(x, startAt = NULL, keep.labels = TRUE)
}
\arguments{
\item{x}{A (factor) variable or a data frame with (factor) variables.}

\item{startAt}{the starting index, i.e. the lowest numeric value of the variable's
value range. By default, this parameter is \code{NULL}, hence the lowest
value of the returned numeric variable corresponds to the lowest factor
level (if factor is \code{\link{numeric}}) or to \code{1} (if factor levels
are not numeric).}

\item{keep.labels}{logical, if \code{TRUE}, former factor levels will be attached as
value labels. See \code{\link{set_val_labels}} for more details.}
}
\value{
A numeric variable with values ranging either from \code{startAt} to
          \code{startAt} + length of factor levels, or to the corresponding
          factor levels (if these were numeric). Or a data frame with numeric
          variables, if \code{x} was a data frame.
}
\description{
This function converts (replaces) factor values with the
related factor level index number, thus the factor is converted to
a numeric variable.
}
\examples{
data(efc)
test <- to_label(efc$e42dep)
table(test)

table(to_value(test))
hist(to_value(test, 0))

# set lowest value of new variable
# to "5".
table(to_value(test, 5))

# numeric factor keeps values
dummy <- factor(c("3", "4", "6"))
table(to_value(dummy))

# non-numeric factor is converted to numeric
# starting at 1
dummy <- factor(c("D", "F", "H"))
table(to_value(dummy))
}
\seealso{
\code{\link{to_label}} to convert a value into a factor with labelled
           factor levels and \code{\link{to_fac}} to convert a numeric variable
           into a factor (and retain labels)
}

