% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mic.R
\name{mic}
\alias{mic}
\title{Mean Inter-Item-Correlation}
\usage{
mic(data, cor.method = "pearson")
}
\arguments{
\item{data}{A \code{matrix} as returned by the \code{\link{cor}}-function, or
a data frame which correlations should be calculated.}

\item{cor.method}{Indicates the correlation computation method. May be one of
\code{"spearman"} (default), \code{"pearson"} or \code{"kendall"}.
You may use initial letter only.}
}
\value{
The value of the computed mean inter-item-correlation.
}
\description{
This function calculates a mean inter-item-correlation, i.e.
               a correlation matrix of \code{data} will be computed (unless
               \code{data} is already a matrix as returned by the
               \code{\link{cor}}-function) and the mean
               of the sum of all item's correlation values is returned.
               Requires either a data frame or a computed \code{\link{cor}}-object.
}
\examples{
# -------------------------------
# Data from the EUROFAMCARE sample dataset
# -------------------------------
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive last item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")
# create data frame with COPE-index scale
df <- data.frame(efc[, c(start:end)])

mic(df)
}

