% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_label.R
\name{to_label}
\alias{to_label}
\title{Convert variable into factor and replaces values with associated value labels}
\usage{
to_label(x, add.non.labelled = FALSE, prefix = FALSE, drop.na = TRUE)
}
\arguments{
\item{x}{A labelled vector (see \code{\link{set_labels}}),
respectively a data frame with such variables.}

\item{add.non.labelled}{logical, if \code{TRUE}, values without associated
value label will also be converted to labels (as is). See 'Examples'.}

\item{prefix}{Logical, if \code{TRUE}, the value labels used as factor levels
will be prefixed with their associated values. See 'Examples'.}

\item{drop.na}{logical, if \code{TRUE}, all types of missing value codes are
converted into NA before \code{x} is converted as factor. If
\code{FALSE}, missing values will be left as their original codes.
See 'Examples' and \code{\link{get_na}}.}
}
\value{
A factor variable with the associated value labels as factor levels, or a
          data frame with such factor variables (if \code{x} was a data frame).
}
\description{
This function converts (replaces) variable values (also of factors
               or character vectors) with their associated value labels. Might
               be helpful for factor variables.
               For instance, if you have a Gender variable with 0/1 value, and associated
               labels are male/female, this function would convert all 0 to male and
               all 1 to female and returns the new variable as \code{\link{factor}}.
}
\details{
See 'Details' in \code{\link{get_na}}.
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_labels}}
        or \code{\link{set_labels}}) will be removed  when converting variables to factors.
        \cr \cr
        Factors with non-numeric factor-levels won't be changed and returned "as is"
        (see 'Examples').
}
\examples{
data(efc)
print(get_labels(efc)['c161sex'])
head(efc$c161sex)
head(to_label(efc$c161sex))

print(get_labels(efc)['e42dep'])
table(efc$e42dep)
table(to_label(efc$e42dep))

head(efc$e42dep)
head(to_label(efc$e42dep))

# structure of numeric values won't be changed
# by this function, it only applies to labelled vectors
# (typically categorical or factor variables)
str(efc$e17age)
str(to_label(efc$e17age))


# factor with non-numeric levels
to_label(factor(c("a", "b", "c")))

# factor with non-numeric levels, prefixed
x <- factor(c("a", "b", "c"))
set_labels(x) <- c("ape", "bear", "cat")
to_label(x, prefix = TRUE)


# create vector
x <- c(1, 2, 3, 2, 4, NA)
# add less labels than values
x <- set_labels(x, c("yes", "maybe", "no"),
                force.labels = FALSE,
                force.values = FALSE)
# convert to label w/o non-labelled values
to_label(x)
# convert to label, including non-labelled values
to_label(x, add.non.labelled = TRUE)


# create labelled integer, with missing flag
x <- labelled(c(1, 2, 1, 3, 4, 1),
              c(Male = 1, Female = 2, Refused = 3, "N/A" = 4),
              c(FALSE, FALSE, TRUE, TRUE))
# to labelled factor, with missing labels
to_label(x, drop.na = FALSE)
# to labelled factor, missings removed
to_label(x, drop.na = TRUE)


# convert labelled character to factor
dummy <- c("M", "F", "F", "X")
set_labels(dummy) <- c(`M` = "Male", `F` = "Female", `X` = "Refused")
get_labels(dummy,, "p")
to_label(dummy)

}
\seealso{
\code{\link{to_factor}} to convert a numeric variable into a factor (and
           preserve labels) and \code{\link{to_value}} to convert a factor into
           a numeric variable.
}

