% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_var.R
\name{find_var}
\alias{find_var}
\title{Find variable by name or label}
\usage{
find_var(data, pattern, ignore.case = TRUE, search = c("name_label",
  "name_value", "label_value", "name", "label", "value", "all"))
}
\arguments{
\item{data}{A data frame.}

\item{pattern}{Character string to be matched in \code{data}. May also be a
character vector of length > 1 (see 'Examples'). \code{pattern} is
searched for in column names and variable label attributes of
\code{data} (see \code{\link{get_label}}). \code{pattern} might also
be a regular-expression object, as returned by \code{\link[stringr]{regex}},
or any of \pkg{stringr}'s supported \code{\link[stringr]{modifiers}}.}

\item{ignore.case}{Logical, whether matching should be case sensitive or not.}

\item{search}{Character string, indicating where \code{pattern} is sought.
Use one of following options:
\describe{
  \item{\code{"name_label"}}{The default, searches for \code{pattern} in
        variable names and variable labels.}
  \item{\code{"name_value"}}{Searches for \code{pattern} in
        variable names and value labels.}
  \item{\code{"label_value"}}{Searches for \code{pattern} in
        variable and value labels.}
  \item{\code{"name"}}{Searches for \code{pattern} in
        variable names.}
  \item{\code{"label"}}{Searches for \code{pattern} in
        variable labels}
  \item{\code{"value"}}{Searches for \code{pattern} in
        value labels.}
  \item{\code{"all"}}{Searches for \code{pattern} in
        variable names, variable and value labels.}
}}
}
\value{
A named vector with column indices of found variables. Variable names
          are used as names-attribute.
}
\description{
This functions finds variables in a data frame, which variable
               names or variable (and value) label attribute match a specific
               pattern. Regular expression for the pattern is supported.
}
\details{
This function searches for \code{pattern} in \code{data}'s column names
           and - for labelled data - in all variable and value labels of \code{data}'s
           variables (see \code{\link{get_label}} for details on variable labels and
           labelled data). Search is performed using the
           \code{\link[stringr]{str_detect}} functions; hence, regular
           expressions are supported as well, by simply using
           \code{pattern = stringr::regex(...)}.
}
\examples{
data(efc)

# find variables with "cop" in variable name
find_var(efc, "cop")

# find variables with "dependency" in names and variable labels
find_var(efc, "dependency")
get_label(efc$e42dep)

# find variables with "level" in names and value labels
res <- find_var(efc, "level", search = "name_value")
res
get_labels(efc[, res], attr.only = FALSE)

# use sjPlot::view_df() to view results
\dontrun{
library(sjPlot)
view_df(efc[, res])}

}

