% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_labels.R
\name{var_rename}
\alias{var_rename}
\title{Rename variables}
\usage{
var_rename(x, ...)
}
\arguments{
\item{x}{Variable (vector), list of variables or a data frame where variables
labels should be added as attribute. For \code{var_labels()}, \code{x}
must be a data frame only.}

\item{...}{Pairs of named vectors, where the name equals the column name that
should be renamed, and the value is the new column name.}
}
\value{
\code{x}, with new column names for those variables specified in \code{...}.
}
\description{
This function renames variables in a data frame, i.e. it
               renames the columns of the data frame.
}
\examples{
# Set variable labels for data frame
dummy <- data.frame(a = sample(1:4, 10, replace = TRUE),
                    b = sample(1:4, 10, replace = TRUE),
                    c = sample(1:4, 10, replace = TRUE))

var_rename(dummy, a = "first.col", c = "3rd.col")

}
