% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dibble}
\alias{dibble}
\title{Degree tibble}
\usage{
dibble(max_degree = 3L)
}
\arguments{
\item{max_degree}{The most distant degree you want to measure (usually between 3-9, default 3).}
}
\value{
A tibble containing the degree, expected kinship coefficient (\code{k}),
lower (\code{l}) and upper (\code{u}) inference bounds.
}
\description{
Creates a tibble with degree, expected kinship coefficient, and inference boundaries.

Rows will be created up to the \code{max_degree}, with an additional row for any
relationship more distant than \code{max_degree}. The \code{degree} value for the final
row will be \code{NA}. This represents inference criteria for "unrelated"
individuals. See examples.
}
\examples{
dibble(3)
dibble(10)

}
