% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_functions.R
\name{competencies_military}
\alias{competencies_military}
\title{Pull from Competencies Military API endpoint.}
\usage{
competencies_military(
  moc,
  service_branch = NULL,
  mpc = NULL,
  exclude = NULL,
  start_date = NULL,
  end_date = NULL,
  moc_status = NULL,
  token,
  handle_status = "warn",
  response_raw = FALSE
)
}
\arguments{
\item{moc}{String or numeric MOC code to return competencies for}

\item{service_branch}{Lowercase Branch of Armed Forces string, e.g. 'army' (Optional)}

\item{mpc}{String (Optional)}

\item{exclude}{Character vector of return elements to exclude (Optional)}

\item{start_date}{Start date of military service (Optional)}

\item{end_date}{End date of military service (Optional)}

\item{moc_status}{Status of MOC (Optional)}

\item{token}{Authorization token obtained from \code{get_access_token}}

\item{handle_status}{How to handle bad HTTP status. Set as either \code{warn} or \code{error}}

\item{response_raw}{Logical value whether to return the API response as
raw, unparsed text. Defaults to \code{FALSE}}
}
\value{
A list of length 12; military competencies data relevant to query
}
\description{
Pull from Competencies Military API endpoint.
}
\examples{
\dontrun{
tkn <- get_access_token(client_id, client_secret)
c <- competencies_military(moc = "2A554E", token = tkn)
}
}
