% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{skim_format}
\alias{skim_format}
\alias{skim_format_defaults}
\title{Change the formatting options for printed skim objects}
\usage{
skim_format(...)

skim_format_defaults()
}
\arguments{
\item{...}{Named arguments that contain named lists specifying formats
to apply.}
}
\value{
Nothing. \code{invisible(NULL)}
}
\description{
Skim uses \code{\link{format}} to convert the numeric values returned by
the summary functions into displayed values. The default options are a
subset of options available in that function.
}
\details{
Generally speaking, formats are dispatched according to the type of value
returned by the "skimmer," i.e. summary function. One special formatting
"type" exists for the names of the returned vector. The names are used
to assign the levels for statistics that have more than one value. Counts
and quantiles are common cases.

When a vector is named, the name and the value are combined into a single
formatted value. To deal with excessively long names for factor levels,
only the first three characters of the name are returned by default. This
can be changed by setting a new value for \code{max_char} within the
\code{.levels} type.
}
\section{Functions}{
\itemize{
\item \code{skim_format_defaults}: Use the default formatting options within skim
}}

\examples{
# Format numbers to have more digits
skim_format(numeric = list(digits = 3))

# Show 4-character names in factor levels
skim_format(.levels = list(nchar = 4))

# Reset to the defaults
skim_format_defaults()
}
