% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RugglesRSC-data.R
\docType{data}
\name{RugglesRSC}
\alias{RugglesRSC}
\title{Recumbent Stone Circle Data}
\format{A data frame with 37 rows and 2 variables:
 \describe{
   \item{Dec}{Declination}
   \item{ID}{Site ID}
   }}
\usage{
data(RugglesRSC)
}
\description{
Declination data from C.L.N. Ruggles' fieldwork on the Scottish Recumbent Stone Circles.
}
\examples{
data(RugglesRSC)
curv <- curvigram(RugglesRSC$Dec, 2)
plotCurv(curv)
}
\references{
Ruggles, C.L.N. (1999). \emph{Astronomy in Prehistoric Britain and Ireland}. Yale University Press.
}
\keyword{datasets}
