% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizon.R
\name{createHor}
\alias{createHor}
\title{Create .\emph{skyscapeR.horizon} object from Az/Alt data}
\usage{
createHor(az, alt, loc, name)
}
\arguments{
\item{az}{Array of azimuth values}

\item{alt}{Array of altitude values.}

\item{loc}{Location, a vector containing the latitude and longitude of
the location, in this order.}

\item{name}{Name of site.}
}
\description{
This function creates a \emph{skyscapeR.horizon} object from measurements of
azimuth and altitude.
}
\examples{
# Create a skyscapeR.horizon from 5 measurements:
az <- c(0,90,180,270,360)
alt <- c(0,5,5,0,0)
hor <- createHor(az, alt, c(40.1,-8), 'Test')
plotHor(hor)
}
\seealso{
\code{\link{plotHor}}
}
