% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{sMjLX}
\alias{sMjLX}
\title{Declination of southern major Lunar Extreme for a given year}
\usage{
sMjLX(
  year = skyscapeR.env$cur.year,
  loc = FALSE,
  parallax = 0.952,
  altitude = 0,
  verbose = TRUE
)
}
\arguments{
\item{year}{Year for which to calculate the declination.
Defaults to present year as given by \emph{Sys.Date}.}

\item{loc}{(Optional) This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object. If missing or \emph{FALSE},
function will output geocentric declination.}

\item{parallax}{(Optional) Average parallax value for the moon
Defaults to 0.952.}

\item{altitude}{(Optional) Altitude of the sun. Defaults to 0 degrees.}

\item{verbose}{(Optional) Boolean to control output of warnings and messages.
Defaults to TRUE.}
}
\description{
This function calculates the declination of the southern
major Lunar Extreme for a given year, based upon
obliquity estimation and corrected average parallax.
}
\examples{
# Southern major Lunar Extreme geocentric declination for year 2501 BC:
sMjLX(-2500)

# Topocentric declination for same year and latitude of 50 degrees N:
sMjLX(-2500, loc=50)
}
\seealso{
\code{\link{nmnLX}}, \code{\link{smnLX}}, \code{\link{nMjLX}},
\code{\link{parallax.corr}}
}
