% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.hats.R
\name{extract.hats}
\alias{extract.hats}
\title{Obtain the concentrated maximum likelihood estimators from a specified model.}
\usage{
extract.hats(slgf.obj, model.index = NULL)
}
\arguments{
\item{slgf.obj}{output from \code{ms.slgf}}

\item{model.index}{the model index of the model for which estimates are desired.}
}
\value{
\code{extract.hats} returns a list with the following elements:\cr
1) \code{model}, the model desired\cr
2) \code{scheme}, the scheme associated with the model desired\cr
3) \code{coef}, the regression coefficients associated with the model desired\cr
4) \code{sigsq}, the error variance(s) assicoated with the model desired\cr
5) \code{g}, the g estimate, if \code{prior="zs"}\cr
}
\description{
\code{extract.hats} Returns the concentrated maximum likelihood estimators from a specified model.
}
\examples{
# Obtain the concentrated maximum likelihood estimates
# for the second-most probable model.

library(numDeriv)

set.seed(314159)
test.data <- data.frame("y"=c(rnorm(10,0,1), rnorm(10,3,1), rnorm(10,5,3)),
                        "x"=c(rep("A",10), rep("B",10), rep("C",10)))
test.models <- list("y~1", "y~x", "y~group")
test.models
test.out <- ms.slgf(dataf=test.data, response="y", lgf="x",
                    usermodels=test.models,
                    prior="flat", het=c(1,1,1), min.levels=1)
extract.hats(test.out, 2)
}
