% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slippymath.R
\name{lonlat_to_tilenum}
\alias{lonlat_to_tilenum}
\title{lonlat_to_tilenum}
\usage{
lonlat_to_tilenum(lon_deg, lat_deg, zoom)
}
\arguments{
\item{lon_deg}{degrees longitude for point}

\item{lat_deg}{degrees latitude for point}

\item{zoom}{zoom level for tile calculation. Increasing zoom increases the
number of tiles.}
}
\value{
a list containing `x` and `y` - the tile numbers.
}
\description{
Convert longitude and latitude to slippy tile numbers
}
\details{
Returns the Open Street Map slippy map tile numbers (x, y) the
supplied latitude and longitude fall on, for a given zoom level.

The point specified by lon_deg` and `lat_deg` is assumed to be in ESPG:4326
coordinate reference system.
}
\examples{
lonlat_to_tilenum(
 lon = 13.37771496361961,
 lat = 52.51628011262304,
 zoom = 17
)
}
