% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.sumiv.plot}
\alias{smbinning.sumiv.plot}
\title{Plot Information Value Summary}
\usage{
smbinning.sumiv.plot(sumivt, cex = 0.9)
}
\arguments{
\item{sumivt}{A data frame saved after \code{smbinning.sumiv}.}

\item{cex}{Optional parameter for the user to control the font size of the characteristics
displayed on the chart. The default value is 0.9}
}
\value{
The command \code{smbinning.sumiv.plot} returns a plot that shows the IV
for each numeric and factor characteristic in the dataset.
}
\description{
It gives the user the ability to plot the Information Value by characteristic.
The chart only shows characteristics with a valid IV.
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Summary Information Value (Exploratory)
testiv=smbinning.sumiv(test,y="FlagGB") 

# Plot IV
smbinning.sumiv.plot(testiv)
}
