% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximate_memory_requirements.R
\name{approximate_memory_requirements}
\alias{approximate_memory_requirements}
\title{Estimate Memory Requirements for SME Routine}
\usage{
approximate_memory_requirements(
  n_samples,
  n_snps,
  n_blocks,
  n_randvecs,
  chunksize
)
}
\arguments{
\item{n_samples}{Integer. The number of samples in the dataset.}

\item{n_snps}{Integer. The total number of SNPs in the dataset.}

\item{n_blocks}{Integer. The number of genotype blocks used to partition SNPs.
Affects the size of encoded genotype segments.}

\item{n_randvecs}{Integer. The number of random vectors used for stochastic
trace estimation. Affects memory for operations involving random vectors.}

\item{chunksize}{Integer. The number of focal SNPs processed per chunk.}
}
\value{
Numeric. The approximate memory requirement (in gigabytes) for the
SME routine.
}
\description{
This function provides an approximate estimate of the memory requirements
(in gigabytes) for running the Sparse Marginal Epistasis (SME) routine
based on input parameters such as the number of samples, SNPs, and other configurations.
}
\details{
The function calculates memory usage by summing the contributions from
various components used in the SME routine, including:
\itemize{
\item Variance component estimates (\code{vc_estimates})
\item Phenotype-related matrices
\item Random vector-based computations
\item Genotype objects and block statistics
\item Gene-by-gene interaction masks
}

The estimated memory requirement is derived from the data dimensions
and operational needs, and it provides a guideline for configuring resources
for the analysis.
}
\examples{
n_samples <- 1e5
n_snps <- 1e6
n_blocks <- 100
n_randvecs <- 100
chunksize <- 10
approximate_memory_requirements(n_samples,
                                n_snps,
                                n_blocks,
                                n_randvecs,
                                chunksize)

}
