% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic.sim.old.R
\name{elliptic.sim}
\alias{elliptic.sim}
\title{Perform \code{elliptic.test} on simulated data}
\usage{
elliptic.sim(
  nsim = 1,
  nn,
  ty,
  ex,
  a,
  shape_all,
  ein,
  eout,
  cl = NULL,
  min.cases = 2
)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{nn}{A list of nearest neighbors produced by
\code{\link{elliptic.nn}}.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{a}{The penalty for the spatial scan statistic.  The
default is 0.5.}

\item{shape_all}{A vector of the shapes associated with
all of the possible zones constructed from \code{nn}.
This can be obtained from \code{\link{elliptic.nn}}.}

\item{ein}{The expected number of cases in the zone.
Conventionally, this is the estimated overall disease
risk across the study area, multiplied by the total
population size of the zone.}

\item{eout}{The expected number of cases outside the
zone.  This should be \code{ty - ein} and is computed
automatically if not provided.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{elliptic.sim} efficiently performs
\code{\link{elliptic.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{elliptic.test}} function, but is informative
for better understanding the implementation of the test.
}
\examples{
data(nydf)
data(nyw)
coords <- with(nydf, cbind(longitude, latitude))
pop <- nydf$pop
enn <- elliptic.nn(coords, pop,
  ubpop = 0.1,
  shape = c(1, 1.5), nangle = c(1, 4)
)
cases <- floor(nydf$cases)
ty <- sum(cases)
ex <- ty / sum(pop) * pop
yin <- nn.cumsum(enn$nn, cases)
ein <- nn.cumsum(enn$nn, ex)
tsim <- elliptic.sim(
  nsim = 2, nn = enn$nn, ty = ty, ex = ex,
  a = 0.5, shape_all = enn$shape_all,
  ein = ein, eout = ty - ein
)
}
\keyword{internal}
