% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smerc_cluster.R
\name{smerc_cluster}
\alias{smerc_cluster}
\title{Prepare \code{smerc_cluster}}
\usage{
smerc_cluster(
  tobs,
  zones,
  pvalue,
  coords,
  cases,
  pop,
  ex,
  longlat,
  method,
  rel_param,
  alpha,
  w = NULL,
  d = NULL,
  a = NULL,
  shape_all = NULL,
  angle_all = NULL,
  weights = NULL
)
}
\arguments{
\item{tobs}{The vector of observed test statistics for each zone}

\item{zones}{A list of zones}

\item{pvalue}{The p-value associated with each test statistic}

\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{method}{A character string indicating the method
used to construct the \code{smerc_cluster}.}

\item{rel_param}{A names list with the relevant parameters
associated with \code{method}.}

\item{alpha}{The significance level of the test.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{d}{A precomputed distance matrix based on \code{coords}}

\item{a}{A single value >= 0 indicating the penalty to use
for \code{\link{elliptic.test}}.}

\item{shape_all}{A vector of shape parameters associated
with \code{zones}.}

\item{angle_all}{A vector of angle parameter associated with
\code{zones}.}

\item{weights}{A vector of weights that multiply the \code{cases}, \code{ex}, and
\code{pop} prior to computing summary statistics.}
}
\value{
A \code{smerc_cluster} object. The object
generally has the following components:
\item{clusters}{A list containing information about the significant
clusters.  See further details below.}
\item{coords}{The matrix of centroid coordinates.}
\item{number_of_regions}{The number of regions considered.}
\item{total_population}{The total population in the regions.}
\item{total_cases}{The total number of cases in the regions.}
\item{cases_per_100k}{The rate of cases per 100,000 persons.}
\item{method}{The name of the method applied.}
\item{rel_param}{A list of relevant method parameters.}
\item{alpha}{The significance level.}
\item{longlat}{A logical value indicating which type
of distance was used.}

Each element of the \code{clusters} component has:
\item{locids}{The ids of the regions in the cluster.}
\item{centroid}{The cluster centroid.}
\item{r}{The radius of the region (from the starting
region to last region of the cluster).}
\item{max_dist}{The maximum intercentroid distance between
all the regions in the cluster.}
\item{population}{The total population in the cluster.}
\item{cases}{The number of cases in the cluster.}
\item{expected}{The expected number of cases in the cluster.}
\item{smr}{Standardized mortality ratio
(\code{cases/expected}) in the cluster.}
\item{rr}{Relative risk in the cluster window. This is
\code{(cases/pop)/((total_cases - cases)/
(total_population - population))}.}
\item{loglikrat}{The log of the likelihood ratio test
statistic for the cluster. Only valid for the scan-type
tests.}
\item{test_statistic}{The test statistic for the cluster.}
\item{pvalue}{The p-value of the test statistic
associated with the cluster.}
\item{w}{The adjacency information for the cluster.}

For \code{\link{elliptic.test}}, \code{clusters}
additionally has:
\item{semiminor_axis}{The semi-minor axis length for the
ellipse.}
\item{semimajor_axis}{The
semi-major axis length for the ellipse.}
\item{angle}{The rotation angle of the ellipse.}
\item{shape}{The shape of the ellipse.}
}
\description{
\code{smerc_cluster} prepares a \code{smerc_cluster}.
}
