% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filterFunctionByTags.R
\name{filterFunctionsByTags}
\alias{filterFunctionsByTags}
\title{Get a list of implemented test functions with specific tags.}
\usage{
filterFunctionsByTags(tags)
}
\arguments{
\item{tags}{[\code{character}]\cr
Character vector of tags. All available tags can be determined with a call
to \code{\link{getAvailableTags}}.}
}
\value{
[\code{character}]
  Named vector of function names with the given tags.
}
\description{
Get a list of implemented test functions with specific tags.
}
\examples{
# show all functions which are unimodal
filterFunctionsByTags("unimodal")
# show all functions which are both unimodal and separable
filterFunctionsByTags(c("unimodal", "separable"))
}

