% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_methods.R
\name{Ops.sk}
\alias{Ops.sk}
\title{Operations group generics}
\usage{
\method{Ops}{sk}(e1, e2)
}
\arguments{
\item{e1}{a "sk" object, vector or matrix}

\item{e2}{a "sk" object, vector or matrix}
}
\value{
a "sk" object (a copy of \code{e1} or \code{e2}) with modified data values
}
\description{
Applies the operation point-wise to grid data values.
}
\details{
The function extracts the grid data \code{x[]} from all sk class arguments \code{x}, prior to
calling the default method. Before returning, the result is copied back to the grid object
of the second argument (or the first, if the second is not of class "sk").

Note that the compatibility of the two arguments is not checked beyond matching
dimension (with vectors recycled as needed). This means for example you can do
operations on two grids representing different areas, so long as they have the
same \code{gdim}.
}
\examples{
g = sk_validate(list(gval=stats::rnorm(4^2), gdim=4, gres=0.5))

# verify a trig identity using Ops and Math
summary( cos(g)^2 + sin(g)^2 )

# create a logical grid indicating points satisfying a condition
plot(g < 0)
all( !(g > 0) == (g[] < 0) )

# test negation
all( (-g)[] == -(g[]) )

}
