% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.summary.table.R
\name{model.summary.table}
\alias{model.summary.table}
\title{Generate a Summary Table for a Linear Model}
\usage{
model.summary.table(model, caption)
}
\arguments{
\item{model}{A linear model object (e.g., output from `lm()`).}

\item{caption}{A character string to be used as the caption for the table.}
}
\value{
A LaTeX-formatted table generated by `kableExtra::kable()`.
}
\description{
This function creates a summary table for a linear model, including coefficients,
standard errors, p-values, and model statistics (e.g., MSE, R-squared). The table
is formatted for LaTeX output using the `kableExtra` package.
}
\examples{
# Fit a linear model
model <- lm(mpg ~ wt + hp, data = mtcars)

# Generate the summary table
model.summary.table(model, caption = "Linear Model Summary")
}
